/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.bean;

import com.atlassian.greenhopper.api.rank.RankService;
import com.atlassian.greenhopper.api.rest.bean.IssueListForBulkEditRetriever;
import com.atlassian.greenhopper.api.rest.bean.IssueRankRequestBean;
import com.atlassian.greenhopper.api.rest.util.IssueResourceHelper;
import com.atlassian.greenhopper.api.rest.util.ServiceOutcomeImpl;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueRankRequestBeanValidator {
    private final IssueResourceHelper issueResourceHelper;
    private final IssueListForBulkEditRetriever issueListForBulkEditRetriever;
    private final RankService rankService;

    @Autowired
    public IssueRankRequestBeanValidator(IssueResourceHelper issueResourceHelper, IssueListForBulkEditRetriever issueListForBulkEditRetriever, RankService rankService) {
        this.issueResourceHelper = issueResourceHelper;
        this.issueListForBulkEditRetriever = issueListForBulkEditRetriever;
        this.rankService = rankService;
    }

    public ServiceOutcome<ValidRankRequest> validateRankRequest(@Nullable ApplicationUser user, IssueRankRequestBean issueRankRequestBean) {
        boolean bothRankBeforeAndAfterAreDefined;
        boolean noIssueRankBeforeOrAfter = issueRankRequestBean.getRankBeforeIssue() == null && issueRankRequestBean.getRankAfterIssue() == null;
        boolean bl = bothRankBeforeAndAfterAreDefined = issueRankRequestBean.getRankBeforeIssue() != null && issueRankRequestBean.getRankAfterIssue() != null;
        if (noIssueRankBeforeOrAfter || bothRankBeforeAndAfterAreDefined) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.api.rank.error.before.or.after.required", new Object[0]);
        }
        ServiceOutcome<Long> rankFieldId = this.getRankFieldId(issueRankRequestBean.getRankCustomFieldId());
        if (!rankFieldId.isValid()) {
            return ServiceOutcomeImpl.from(this.notFoundToValidationFailed(rankFieldId.getErrors()));
        }
        ServiceOutcome<Issue> positionIssue = this.getRankToIssue(user, issueRankRequestBean);
        if (!positionIssue.isValid()) {
            return ServiceOutcomeImpl.from(this.notFoundToValidationFailed(positionIssue.getErrors()));
        }
        ServiceOutcome<Iterable<Issue>> issuesForKeysAndIds = this.issueListForBulkEditRetriever.retrieveIssuesFromKeysAndIds(user, issueRankRequestBean.getIssues());
        if (!issuesForKeysAndIds.isValid()) {
            return ServiceOutcomeImpl.error(issuesForKeysAndIds);
        }
        boolean isRankBefore = issueRankRequestBean.getRankBeforeIssue() != null;
        return ServiceOutcomeImpl.ok(new ValidRankRequest((List)ImmutableList.copyOf((Iterable)((Iterable)issuesForKeysAndIds.get())), (Issue)positionIssue.get(), (Long)rankFieldId.get(), isRankBefore));
    }

    private ServiceOutcome<Issue> getRankToIssue(ApplicationUser user, IssueRankRequestBean issueRankRequestBean) {
        if (issueRankRequestBean.getRankAfterIssue() == null) {
            return this.issueResourceHelper.getIssueForKeyOrId(user, issueRankRequestBean.getRankBeforeIssue());
        }
        return this.issueResourceHelper.getIssueForKeyOrId(user, issueRankRequestBean.getRankAfterIssue());
    }

    private ServiceOutcome<Long> getRankFieldId(@Nullable Long rankFieldId) {
        if (rankFieldId == null) {
            ServiceOutcome defaultRankField = ServiceOutcomeImpl.from(this.rankService.getDefaultRankField());
            if (defaultRankField.isValid()) {
                return ServiceOutcomeImpl.ok(((CustomField)defaultRankField.get()).getIdAsLong());
            }
            return ServiceOutcomeImpl.error(defaultRankField);
        }
        if (!this.rankService.isRankField(rankFieldId.longValue())) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.api.rank.error.custom.field.not.found", rankFieldId);
        }
        return ServiceOutcomeImpl.ok(rankFieldId);
    }

    private ErrorCollection notFoundToValidationFailed(ErrorCollection errorCollection) {
        if (!errorCollection.getDefinitiveReason().equals((Object)ErrorCollection.Reason.NOT_FOUND)) {
            return errorCollection;
        }
        ErrorCollection newErrorCollection = new ErrorCollection();
        newErrorCollection.addAllErrorsWithoutReason(errorCollection);
        newErrorCollection.addReason(ErrorCollection.Reason.VALIDATION_FAILED);
        return newErrorCollection;
    }

    public static class ValidRankRequest {
        private final List<Issue> issues;
        private final Issue positionIssue;
        private final Long rankCustomFieldId;
        private final boolean isRankBefore;

        private ValidRankRequest(List<Issue> issues, Issue positionIssue, Long rankCustomFieldId, boolean isRankBefore) {
            this.issues = issues;
            this.positionIssue = positionIssue;
            this.rankCustomFieldId = rankCustomFieldId;
            this.isRankBefore = isRankBefore;
        }

        public List<Issue> getIssues() {
            return this.issues;
        }

        public Issue getPositionIssue() {
            return this.positionIssue;
        }

        public boolean isRankBefore() {
            return this.isRankBefore;
        }

        public Long getRankCustomFieldId() {
            return this.rankCustomFieldId;
        }
    }
}

