/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.bean;

import com.atlassian.greenhopper.api.rest.bean.BeanFactories;
import com.atlassian.greenhopper.api.rest.bean.EpicBean;
import com.atlassian.greenhopper.api.rest.bean.EpicBeanFactory;
import com.atlassian.greenhopper.api.rest.bean.SelfLinkFactory;
import com.atlassian.greenhopper.api.rest.bean.SprintBean;
import com.atlassian.greenhopper.api.rest.bean.SprintBeanFactory;
import com.atlassian.greenhopper.service.Page;
import com.atlassian.greenhopper.service.issue.RapidViewIssue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.jira.rest.v2.issue.IssueBeanBuilder;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.rest.v2.search.SearchResultsBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugins.rest.common.expand.EntityCrawler;
import com.atlassian.plugins.rest.common.expand.SelfExpandingExpander;
import com.atlassian.plugins.rest.common.expand.parameter.DefaultExpandParameter;
import com.atlassian.plugins.rest.common.expand.parameter.ExpandParameter;
import com.atlassian.plugins.rest.common.expand.resolver.EntityExpanderResolver;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BoardIssueBeanFactory {
    public static final String EPIC_FIELD_ID = "epic";
    public static final String SPRINT_FIELD_ID = "sprint";
    public static final String CLOSED_SPRINTS_FIELD_ID = "closedSprints";
    public static final String FLAGGED_FIELD_ID = "flagged";
    private final BeanBuilderFactory beanBuilderFactory;
    private final SelfLinkFactory selfLinkFactory;
    private final EpicBeanFactory epicBeanFactory;
    private final SprintBeanFactory sprintBeanFactory;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public BoardIssueBeanFactory(BeanBuilderFactory beanBuilderFactory, SelfLinkFactory selfLinkFactory, EpicBeanFactory epicBeanFactory, SprintBeanFactory sprintBeanFactory, JiraAuthenticationContext jiraAuthenticationContext) {
        this.beanBuilderFactory = beanBuilderFactory;
        this.selfLinkFactory = selfLinkFactory;
        this.epicBeanFactory = epicBeanFactory;
        this.sprintBeanFactory = sprintBeanFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public IssueBean toBean(RapidViewIssue from, List<StringList> fields, String expand) {
        IncludedFields includedFields = IncludedFields.includeAllByDefault(fields);
        IssueBeanBuilder issueBeanBuilder = this.beanBuilderFactory.newIssueBeanBuilder(from.getIssue(), includedFields);
        issueBeanBuilder.uriBuilder(UriBuilder.fromUri((URI)this.selfLinkFactory.selfLink(new String[0])));
        issueBeanBuilder.expand(expand);
        IssueBean issueBean = issueBeanBuilder.build();
        if (from.getEpic() != null) {
            EpicBean epicBean = this.epicBeanFactory.toBean(from.getEpic());
            this.addField(issueBean, EPIC_FIELD_ID, "gh.issue.epic", epicBean);
        }
        if (from.getSprint() != null) {
            SprintBean sprintBean = this.sprintBeanFactory.toBean(from.getSprint());
            this.addField(issueBean, SPRINT_FIELD_ID, "gh.sprint", sprintBean);
        }
        if (from.getClosedSprints() != null && !from.getClosedSprints().isEmpty()) {
            List<SprintBean> closedSprintsBeans = BeanFactories.toBeans(this.sprintBeanFactory, from.getClosedSprints());
            this.addField(issueBean, CLOSED_SPRINTS_FIELD_ID, "gh.sprint.complete.status", closedSprintsBeans);
        }
        this.addField(issueBean, FLAGGED_FIELD_ID, "gh.issue.flaggingfield", from.isFlagged());
        return issueBean;
    }

    public SearchResultsBean toBeans(Page<RapidViewIssue> page, final List<StringList> fields, final String expand) {
        ImmutableList expands = expand != null ? ImmutableList.copyOf((Iterable)Splitter.on((String)",").split((CharSequence)expand)) : Collections.emptyList();
        SelfExpandingExpander.Resolver expandResolver = new SelfExpandingExpander.Resolver();
        final DefaultExpandParameter defaultExpandParameter = new DefaultExpandParameter((Collection)expands);
        final EntityCrawler entityCrawler = new EntityCrawler();
        ImmutableList issueBeans = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)page.getValues(), (Function)new Function<RapidViewIssue, IssueBean>((EntityExpanderResolver)expandResolver){
            final /* synthetic */ EntityExpanderResolver val$expandResolver;
            {
                this.val$expandResolver = entityExpanderResolver;
            }

            public IssueBean apply(@Nullable RapidViewIssue input) {
                IssueBean issueBean = BoardIssueBeanFactory.this.toBean(input, fields, expand);
                entityCrawler.crawl((Object)issueBean, (ExpandParameter)defaultExpandParameter, this.val$expandResolver);
                return issueBean;
            }
        }));
        Integer total = page.getTotal() != null ? Integer.valueOf(page.getTotal().intValue()) : null;
        return new SearchResultsBean(Integer.valueOf(page.getStart().intValue()), page.maxResults(), total, (List)issueBeans);
    }

    private void addField(IssueBean issueBean, String id, String nameKey, Object data) {
        String name = this.jiraAuthenticationContext.getI18nHelper().getText(nameKey);
        SimpleField field = new SimpleField(id, nameKey, name);
        issueBean.addField((Field)field, new FieldJsonRepresentation(new JsonData(data)), false);
    }

    private static class SimpleField
    implements Field {
        private final String id;
        private final String nameKey;
        private final String name;

        SimpleField(String id, String nameKey, String name) {
            this.id = id;
            this.nameKey = nameKey;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getNameKey() {
            return this.nameKey;
        }

        public String getName() {
            return this.name;
        }

        public int compareTo(@Nullable Object o) {
            if (o == null) {
                return 1;
            }
            if (o instanceof Field) {
                Field field = (Field)o;
                if (this.getName() == null) {
                    if (field.getName() == null) {
                        return 0;
                    }
                    return -1;
                }
                if (field.getName() == null) {
                    return 1;
                }
                return this.getName().compareTo(field.getName());
            }
            throw new IllegalArgumentException("Can only compare Field objects.");
        }
    }
}

