/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.bean;

import com.atlassian.greenhopper.api.rest.bean.BoardCreateBean;
import com.atlassian.greenhopper.api.rest.util.ServiceOutcomeImpl;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.web.rapid.view.RapidViewPreset;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public final class BoardCreateBeanValidator {
    public ServiceOutcome<ValidCreateBoardRequest> validate(BoardCreateBean boardCreateBean) {
        if (boardCreateBean.getName() == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.board.error.name.required", new Object[0]);
        }
        if (boardCreateBean.getType() == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.board.error.type.required", new Object[0]);
        }
        Optional rapidViewPreset = RapidViewPreset.get((String)boardCreateBean.getType());
        if (!rapidViewPreset.isPresent()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.board.error.type.invalid", boardCreateBean.getType());
        }
        if (boardCreateBean.getFilterId() == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.board.error.filterid.required", new Object[0]);
        }
        return ServiceOutcomeImpl.ok(new ValidCreateBoardRequest(boardCreateBean.getName(), (RapidViewPreset)rapidViewPreset.get(), boardCreateBean.getFilterId()));
    }

    public static final class ValidCreateBoardRequest {
        private final String name;
        private final RapidViewPreset rapidViewPreset;
        private final long filterId;

        private ValidCreateBoardRequest(String name, RapidViewPreset rapidViewPreset, long filterId) {
            this.name = name;
            this.rapidViewPreset = rapidViewPreset;
            this.filterId = filterId;
        }

        public String getName() {
            return this.name;
        }

        public RapidViewPreset getRapidViewPreset() {
            return this.rapidViewPreset;
        }

        public long getFilterId() {
            return this.filterId;
        }
    }
}

