/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.bean;

import com.atlassian.greenhopper.api.rapid.view.Column;
import com.atlassian.greenhopper.api.rest.bean.BoardConfigBean;
import com.atlassian.greenhopper.model.rapid.ColumnConfig;
import com.atlassian.greenhopper.model.rapid.EstimationConfig;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.util.JiraUrlCodec;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BoardConfigBeanColumnUtils {
    private final JiraBaseUrls jiraBaseUrls;

    @Autowired
    public BoardConfigBeanColumnUtils(JiraBaseUrls jiraBaseUrls) {
        this.jiraBaseUrls = jiraBaseUrls;
    }

    BoardConfigBean.EstimationConfigBean createEstimationConfigBean(EstimationConfig estimationConfig) {
        if (estimationConfig == null) {
            return null;
        }
        String type = estimationConfig.getType().getId();
        BoardConfigBean.EstimationFieldBean estimationFieldBean = this.getEstimationFieldBean(estimationConfig.getField());
        return new BoardConfigBean.EstimationConfigBean(type, estimationFieldBean);
    }

    BoardConfigBean.ColumnConfigBean createColumnConfigBean(ColumnConfig columnConfig) {
        return new BoardConfigBean.ColumnConfigBean(this.createColumnBeans(columnConfig.getColumns()), columnConfig.getConstraintType().getId());
    }

    private List<BoardConfigBean.ColumnBean> createColumnBeans(List<Column> columns) {
        return columns.stream().map(this::createColumnBean).collect(Collectors.toList());
    }

    private BoardConfigBean.ColumnBean createColumnBean(Column column) {
        List statusBeans = column.getStatuses().stream().map(status -> {
            String statusId = status.getSimpleStatus().getId();
            URI self = UriBuilder.fromPath((String)this.jiraBaseUrls.restApi2BaseUrl()).path("status").path(JiraUrlCodec.encode((String)statusId)).build(new Object[0]);
            return new BoardConfigBean.RelationBean(statusId, self);
        }).collect(Collectors.toList());
        return new BoardConfigBean.ColumnBean(column.getName(), (List<BoardConfigBean.RelationBean>)ImmutableList.copyOf(statusBeans), column.getMin(), column.getMax());
    }

    @Nullable
    private BoardConfigBean.EstimationFieldBean getEstimationFieldBean(@Nullable Field field) {
        if (field == null) {
            return null;
        }
        return new BoardConfigBean.EstimationFieldBean(field.getId(), field.getName());
    }
}

