/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.bean;

import com.atlassian.greenhopper.api.rest.bean.BeanFactory;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.List;

public class BeanFactories {
    private BeanFactories() {
    }

    public static <F, T> Function<F, T> toBeanFunction(final BeanFactory<F, T> beanFactory) {
        return new Function<F, T>(){

            public T apply(F input) {
                return beanFactory.toBean(input);
            }
        };
    }

    public static <F, T> List<T> toBeans(BeanFactory<F, T> beanFactory, Iterable<? extends F> from) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(from, BeanFactories.toBeanFunction(beanFactory)));
    }

    public static <F, T> List<T> toBeans(BeanFactory<F, T> beanFactory, Iterable<? extends F> from, Ordering<F> ordering) {
        return Lists.transform((List)ordering.sortedCopy(from), BeanFactories.toBeanFunction(beanFactory));
    }

    public static <F, T> Function<Iterable<F>, List<T>> toBeansFunction(final BeanFactory<F, T> beanFactory) {
        return new Function<Iterable<F>, List<T>>(){

            public List<T> apply(Iterable<F> input) {
                return BeanFactories.toBeans(beanFactory, input);
            }
        };
    }
}

