/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest;

import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintPropertyService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.v2.entity.property.BasePropertyResource;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="sprint/{sprintId}/properties")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
public class SprintPropertyResource {
    private final BasePropertyResource<Sprint> delegate;

    public SprintPropertyResource(SprintPropertyService sprintPropertyService, JiraAuthenticationContext authContext, JiraBaseUrls jiraBaseUrls) {
        this.delegate = new BasePropertyResource((EntityPropertyService)sprintPropertyService, authContext, jiraBaseUrls, (I18nHelper)ComponentAccessor.getComponentOfType(I18nHelper.class), (entityId, encodedPropertyKey) -> String.format("sprint/%d/properties/%s", entityId, encodedPropertyKey), SprintPropertyService.SPRINT_ENTITY_PROPERTY_TYPE);
    }

    @GET
    public Response getPropertiesKeys(@PathParam(value="sprintId") String sprintId) {
        return this.delegate.getPropertiesKeys(sprintId);
    }

    @GET
    @Path(value="/{propertyKey}")
    public Response getProperty(@PathParam(value="sprintId") String sprintId, @PathParam(value="propertyKey") String propertyKey) {
        return this.delegate.getProperty(sprintId, propertyKey);
    }

    @PUT
    @Path(value="/{propertyKey}")
    public Response setProperty(@PathParam(value="sprintId") String sprintId, @PathParam(value="propertyKey") String propertyKey, @Context HttpServletRequest request) {
        return this.delegate.setProperty(sprintId, propertyKey, request);
    }

    @DELETE
    @Path(value="/{propertyKey}")
    public Response deleteProperty(@PathParam(value="sprintId") String sprintId, @PathParam(value="propertyKey") String propertyKey) {
        return this.delegate.deleteProperty(sprintId, propertyKey);
    }
}

