/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest;

import com.atlassian.greenhopper.api.rest.bean.BeanFactories;
import com.atlassian.greenhopper.api.rest.bean.PageBeanFactory;
import com.atlassian.greenhopper.api.rest.bean.VersionBeanFactory;
import com.atlassian.greenhopper.api.rest.util.BoardResourceHelper;
import com.atlassian.greenhopper.api.rest.util.QueryParamParser;
import com.atlassian.greenhopper.api.rest.util.Requests;
import com.atlassian.greenhopper.api.rest.util.ResponseFactory;
import com.atlassian.greenhopper.api.rest.util.ServiceOutcomeImpl;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.Page;
import com.atlassian.greenhopper.service.PageRequest;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.view.RapidViewVersionService;
import com.atlassian.greenhopper.service.rapid.view.VersionQuery;
import com.atlassian.jira.user.ApplicationUser;
import javax.annotation.Nullable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="board/{boardId}/version")
@Produces(value={"application/json"})
public final class BoardVersionResource {
    private static final Integer RETURNED_VERSION_LIMIT = 50;
    private final RapidViewVersionService rapidViewVersionService;
    private final VersionBeanFactory versionBeanFactory;
    private final ResponseFactory responseFactory;
    private final BoardResourceHelper boardResourceHelper;

    public BoardVersionResource(RapidViewVersionService rapidViewVersionService, VersionBeanFactory versionBeanFactory, ResponseFactory responseFactory, BoardResourceHelper boardResourceHelper) {
        this.rapidViewVersionService = rapidViewVersionService;
        this.versionBeanFactory = versionBeanFactory;
        this.responseFactory = responseFactory;
        this.boardResourceHelper = boardResourceHelper;
    }

    @GET
    public Response getAllVersions(@PathParam(value="boardId") Long boardId, final @QueryParam(value="startAt") Long startAt, final @QueryParam(value="maxResults") Integer maxResults, final @QueryParam(value="released") String released) {
        return this.boardResourceHelper.executeWithBoard(boardId, new BoardResourceHelper.WithBoardAction(){

            @Override
            public Response apply(ApplicationUser user, RapidView rapidView) {
                ServiceOutcome versionQuery = BoardVersionResource.this.getVersionQuery(released);
                if (!versionQuery.isValid()) {
                    return BoardVersionResource.this.responseFactory.errorsToResponse(versionQuery.getErrors());
                }
                PageRequest pageRequest = Requests.requestWithLimit(startAt, maxResults, RETURNED_VERSION_LIMIT);
                ServiceOutcome versions = BoardVersionResource.this.rapidViewVersionService.getVersionsForRapidView(user, rapidView, pageRequest, (VersionQuery)versionQuery.get());
                if (!versions.isValid()) {
                    return BoardVersionResource.this.responseFactory.errorsToResponse(versions.getErrors());
                }
                return ResponseFactory.okNoCache(PageBeanFactory.createPageBean((Page)versions.get(), BeanFactories.toBeanFunction(BoardVersionResource.this.versionBeanFactory)));
            }
        });
    }

    private ServiceOutcome<VersionQuery> getVersionQuery(@Nullable String releasedStr) {
        VersionQuery.Builder builder = VersionQuery.builder();
        if (releasedStr != null) {
            ServiceOutcome<Boolean> released = QueryParamParser.parseBoolean(releasedStr, "released");
            if (!released.isValid()) {
                return ServiceOutcomeImpl.error(released);
            }
            builder.released((Boolean)released.get());
        }
        return ServiceOutcomeImpl.ok(builder.build());
    }
}

