/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest;

import com.atlassian.greenhopper.api.rest.bean.BeanFactories;
import com.atlassian.greenhopper.api.rest.bean.BoardBean;
import com.atlassian.greenhopper.api.rest.bean.BoardBeanFactory;
import com.atlassian.greenhopper.api.rest.bean.BoardConfigBean;
import com.atlassian.greenhopper.api.rest.bean.BoardConfigBeanFactory;
import com.atlassian.greenhopper.api.rest.bean.BoardCreateBean;
import com.atlassian.greenhopper.api.rest.bean.BoardCreateBeanValidator;
import com.atlassian.greenhopper.api.rest.bean.PageBean;
import com.atlassian.greenhopper.api.rest.bean.PageBeanFactory;
import com.atlassian.greenhopper.api.rest.util.BoardResourceHelper;
import com.atlassian.greenhopper.api.rest.util.IssueResourceHelper;
import com.atlassian.greenhopper.api.rest.util.ProjectFinder;
import com.atlassian.greenhopper.api.rest.util.QueryParamParser;
import com.atlassian.greenhopper.api.rest.util.Requests;
import com.atlassian.greenhopper.api.rest.util.ResponseFactory;
import com.atlassian.greenhopper.api.rest.util.ServiceOutcomeImpl;
import com.atlassian.greenhopper.license.LicenseService;
import com.atlassian.greenhopper.model.rapid.ColumnConfig;
import com.atlassian.greenhopper.model.rapid.EstimationConfig;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.Page;
import com.atlassian.greenhopper.service.PageRequest;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.issue.RapidViewIssueService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewConfigService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewQuery;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.subquery.Subquery;
import com.atlassian.greenhopper.service.subquery.SubqueryService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="board")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public final class BoardResource {
    private static final Integer RETURNED_BOARD_LIMIT = 50;
    private final RapidViewService rapidViewService;
    private final BoardBeanFactory boardBeanFactory;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final LicenseService licenseService;
    private final ResponseFactory responseFactory;
    private final RapidViewIssueService rapidViewIssueService;
    private final BoardResourceHelper boardResourceHelper;
    private final IssueResourceHelper issueResourceHelper;
    private final BoardConfigBeanFactory boardConfigBeanFactory;
    private final BoardCreateBeanValidator boardCreateBeanValidator;
    private final ProjectFinder projectFinder;
    private final RapidViewConfigService rapidViewConfigService;
    private final SubqueryService subqueryService;

    public BoardResource(RapidViewService rapidViewService, BoardBeanFactory boardBeanFactory, JiraAuthenticationContext jiraAuthenticationContext, LicenseService licenseService, ResponseFactory responseFactory, RapidViewIssueService rapidViewIssueService, BoardResourceHelper boardResourceHelper, IssueResourceHelper issueResourceHelper, BoardConfigBeanFactory boardConfigBeanFactory, BoardCreateBeanValidator boardCreateBeanValidator, ProjectFinder projectFinder, RapidViewConfigService rapidViewConfigService, SubqueryService subqueryService) {
        this.rapidViewService = rapidViewService;
        this.boardBeanFactory = boardBeanFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.licenseService = licenseService;
        this.responseFactory = responseFactory;
        this.rapidViewIssueService = rapidViewIssueService;
        this.boardResourceHelper = boardResourceHelper;
        this.issueResourceHelper = issueResourceHelper;
        this.boardConfigBeanFactory = boardConfigBeanFactory;
        this.boardCreateBeanValidator = boardCreateBeanValidator;
        this.projectFinder = projectFinder;
        this.rapidViewConfigService = rapidViewConfigService;
        this.subqueryService = subqueryService;
    }

    @GET
    public Response getAllBoards(@QueryParam(value="startAt") Long startAt, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="type") StringList type, @QueryParam(value="name") String name, @QueryParam(value="projectKeyOrId") String projectKeyOrId) {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        ServiceResult validateUser = this.licenseService.validateUser(user);
        if (!validateUser.isValid()) {
            return this.responseFactory.errorsToResponse(validateUser);
        }
        PageRequest pageRequest = Requests.requestWithLimit(startAt, maxResults, RETURNED_BOARD_LIMIT);
        ServiceOutcome<RapidViewQuery> rapidViewQuery = this.getRapidViewQuery(user, type, name, projectKeyOrId);
        if (!rapidViewQuery.isValid()) {
            return this.responseFactory.errorsToResponse(rapidViewQuery);
        }
        ServiceOutcome boardPage = this.rapidViewService.getRapidViews(user, pageRequest, (RapidViewQuery)rapidViewQuery.get());
        if (!boardPage.isValid()) {
            return this.responseFactory.errorsToResponse(boardPage);
        }
        PageBean<BoardBean> boardPageBean = PageBeanFactory.createPageBean((Page)boardPage.get(), BeanFactories.toBeanFunction(this.boardBeanFactory));
        return ResponseFactory.okNoCache(boardPageBean);
    }

    private ServiceOutcome<RapidViewQuery> getRapidViewQuery(@Nullable ApplicationUser user, StringList typeNames, @Nullable String nameLike, @Nullable String projectKeyOrId) {
        RapidViewQuery.Builder queryBuilder = RapidViewQuery.builder();
        if (nameLike != null) {
            queryBuilder.partialName(nameLike);
        }
        if (typeNames != null && !typeNames.asList().isEmpty()) {
            ServiceOutcome<Set<RapidView.Type>> types = QueryParamParser.parseEnumSet("type", (List<String>)typeNames.asList(), RapidView.Type.class);
            if (!types.isValid()) {
                return ServiceOutcomeImpl.error(types);
            }
            queryBuilder.types((Set)types.get());
        }
        if (projectKeyOrId != null) {
            ProjectService.GetProjectResult projectFinderResult = this.projectFinder.getGetProjectByIdOrKey(user, projectKeyOrId);
            if (!projectFinderResult.isValid()) {
                return ServiceOutcomeImpl.from(ErrorCollection.fromJiraErrorCollection((com.atlassian.jira.util.ErrorCollection)projectFinderResult.getErrorCollection()));
            }
            queryBuilder.project(projectFinderResult.getProject());
        }
        return ServiceOutcomeImpl.ok(queryBuilder.build());
    }

    @GET
    @Path(value="{boardId}")
    public Response getBoard(@PathParam(value="boardId") Long boardId) {
        return this.boardResourceHelper.executeWithBoard(boardId, (user, rapidView) -> ResponseFactory.okNoCache(this.boardBeanFactory.toBean(rapidView)));
    }

    @GET
    @Path(value="{boardId}/issue")
    public Response getIssuesForBoard(@PathParam(value="boardId") Long boardId, @QueryParam(value="startAt") Long startAt, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="jql") String jql, @QueryParam(value="validateQuery") Boolean validateQuery, @QueryParam(value="fields") List<StringList> fields, @QueryParam(value="expand") String expand) {
        return this.issueResourceHelper.searchIssueByQueryParamsForBoard(boardId, jql, validateQuery, startAt, maxResults, fields, expand, (arg_0, arg_1, arg_2, arg_3) -> ((RapidViewIssueService)this.rapidViewIssueService).getIssuesForRapidView(arg_0, arg_1, arg_2, arg_3));
    }

    @GET
    @Path(value="{boardId}/backlog")
    public Response getIssuesForBacklog(@PathParam(value="boardId") Long boardId, @QueryParam(value="startAt") Long startAt, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="jql") String jql, @QueryParam(value="validateQuery") Boolean validateQuery, @QueryParam(value="fields") List<StringList> fields, @QueryParam(value="expand") String expand) {
        return this.issueResourceHelper.searchIssueByQueryParamsForBoard(boardId, jql, validateQuery, startAt, maxResults, fields, expand, (arg_0, arg_1, arg_2, arg_3) -> ((RapidViewIssueService)this.rapidViewIssueService).getIssuesForBacklog(arg_0, arg_1, arg_2, arg_3));
    }

    @GET
    @Path(value="{boardId}/configuration")
    public Response getConfiguration(@PathParam(value="boardId") Long boardId) {
        return this.boardResourceHelper.executeWithBoard(boardId, (user, rapidView) -> {
            Subquery sanitisedSubquery;
            Long rankFieldId = this.rapidViewConfigService.getRankFieldId(user, rapidView);
            ColumnConfig columnConfig = this.rapidViewConfigService.getColumnConfig(user, rapidView);
            EstimationConfig estimationConfig = this.rapidViewConfigService.getEstimationConfig(user, rapidView);
            if (rapidView.getType() == RapidView.Type.KANBAN) {
                ServiceOutcome outcome = this.subqueryService.getSubquery(user, rapidView);
                if (outcome.isInvalid()) {
                    return this.responseFactory.errorsToResponse(outcome);
                }
                sanitisedSubquery = (Subquery)outcome.get();
            } else {
                sanitisedSubquery = null;
            }
            BoardConfigBean boardConfigBean = this.boardConfigBeanFactory.toBean(rapidView, rankFieldId, columnConfig, estimationConfig, sanitisedSubquery);
            return ResponseFactory.okNoCache(boardConfigBean);
        });
    }

    @POST
    public Response createBoard(BoardCreateBean boardCreateBean) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        ServiceResult validateUser = this.licenseService.validateUser(user);
        if (!validateUser.isValid()) {
            return this.responseFactory.errorsToResponse(validateUser);
        }
        ServiceOutcome<BoardCreateBeanValidator.ValidCreateBoardRequest> validCreateBoardRequestOutcome = this.boardCreateBeanValidator.validate(boardCreateBean);
        if (!validCreateBoardRequestOutcome.isValid()) {
            return this.responseFactory.errorsToResponse(validCreateBoardRequestOutcome);
        }
        BoardCreateBeanValidator.ValidCreateBoardRequest createBoardRequest = (BoardCreateBeanValidator.ValidCreateBoardRequest)validCreateBoardRequestOutcome.get();
        ServiceOutcome rapidViewOutcome = this.rapidViewService.create(user, createBoardRequest.getName(), Long.valueOf(createBoardRequest.getFilterId()), createBoardRequest.getRapidViewPreset());
        if (!rapidViewOutcome.isValid()) {
            return this.responseFactory.errorsToResponse(rapidViewOutcome);
        }
        BoardBean boardBean = this.boardBeanFactory.toBean((RapidView)rapidViewOutcome.get());
        return ResponseFactory.created(boardBean.getSelf(), boardBean);
    }

    @DELETE
    @Path(value="{boardId}")
    public Response deleteBoard(@PathParam(value="boardId") Long boardId) {
        return this.boardResourceHelper.executeWithBoard(boardId, (user, rapidView) -> {
            ServiceResult serviceResult = this.rapidViewService.delete(user, rapidView);
            if (serviceResult.isInvalid()) {
                return this.responseFactory.errorsToResponse(serviceResult);
            }
            return ResponseFactory.noContent();
        });
    }
}

