/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.rapid.BoardPropertyService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.v2.entity.property.BasePropertyResource;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="board/{boardId}/properties")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
public class BoardPropertyResource {
    private final BasePropertyResource<RapidView> delegate;

    public BoardPropertyResource(BoardPropertyService boardPropertyService, JiraAuthenticationContext authContext, JiraBaseUrls jiraBaseUrls) {
        this.delegate = new BasePropertyResource((EntityPropertyService)boardPropertyService, authContext, jiraBaseUrls, (I18nHelper)ComponentAccessor.getComponentOfType(I18nHelper.class), (entityId, encodedPropertyKey) -> String.format("board/%d/properties/%s", entityId, encodedPropertyKey), BoardPropertyService.BOARD_ENTITY_PROPERTY_TYPE);
    }

    @GET
    public Response getPropertiesKeys(@PathParam(value="boardId") String boardId) {
        return this.delegate.getPropertiesKeys(boardId);
    }

    @GET
    @Path(value="/{propertyKey}")
    public Response getProperty(@PathParam(value="boardId") String boardId, @PathParam(value="propertyKey") String propertyKey) {
        return this.delegate.getProperty(boardId, propertyKey);
    }

    @PUT
    @Path(value="/{propertyKey}")
    public Response setProperty(@PathParam(value="boardId") String boardId, @PathParam(value="propertyKey") String propertyKey, @Context HttpServletRequest request) {
        return this.delegate.setProperty(boardId, propertyKey, request);
    }

    @DELETE
    @Path(value="/{propertyKey}")
    public Response deleteProperty(@PathParam(value="boardId") String boardId, @PathParam(value="propertyKey") String propertyKey) {
        return this.delegate.deleteProperty(boardId, propertyKey);
    }
}

