define('layout/loading-overlay/loading-overlay-view',
    [
        'zepto',
        'underscore',
        'backbone',
        'util/presenter'
    ], function ($, _, Backbone, Presenter) {

    return Backbone.View.extend({

        loading: null,
        positionListener: null,

        className: 'loading-overlay',

        events: {
            'click .loading-cancel': 'cancelLoading'
        },

        render: function() {
            this.$el.html(AtlassianMobile.Templates.Common.layout.pageLoading());
            $('#outer-container').append(this.$el);
        },

        showLoading: function() {
            var $indicator = $('.page-loading-indicator');
            var $overlay = $('.loading-overlay').addClass('show');
            $overlay.css('height', $('#inner-container').height());
            var $spinner = $indicator.find('.spinner').spin('small', {
                left: 0,
                top: 'auto'
            });
            var $cancel = $indicator.find('.loading-cancel').show();
            var $success = $indicator.find('.loading-success');
            this.loading = {
                overlay: $overlay,
                indicator: $indicator,
                cancel: $cancel,
                spinner: $spinner.data('spinner')
            };
            this.success = $success;

            this.positionPageSpinner();
            _.defer(function () {
                $indicator.addClass('show');
            });
            this.positionListener =  _.bind(this.positionPageSpinner, this);
            $(window).on('resize scroll', this.positionListener);
        },

        /**
         * Remove any active loading spinners
         */
        hideLoading: function () {
            if (this.loading) {
                this.loading.spinner.stop();
                this.loading.cancel.hide();
                if (this.loading.overlay) {
                    this.loading.overlay.removeClass('show');
                }
                if (this.positionListener) {
                    $(window).off('resize scroll', this.positionListener);
                    this.loading.indicator.removeClass('show');
                }
                this.loading = null;
            }
        },

        /**
         * Make sure a full-page spinner is positioned in the centre of the screen
         */
        positionPageSpinner: function () {
            if (this.loading && this.loading.overlay) {
                var $elem = this.loading.indicator;
                var ew = $elem.width();
                var eh = $elem.height();
                var ww = window.innerWidth;
                var wh = window.innerHeight;
                $elem.css({
                    left: ww / 2 - ew / 2,
                    top: (wh / 2 - eh / 2) + window.scrollY
                });
            }
        },

        /**
         * Cancel any AJAX requests that are currently active for the active PageView
         */
        cancelLoading: function () {
            Presenter.cancelLoading();
        },
    });

});