/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.utils;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.UserAgentUtil;
import com.atlassian.jira.util.UserAgentUtilImpl;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public final class MobileUtils {
    public static final String JIRA_MOBILE_PLUGIN_KEY = "com.atlassian.jira.mobile.jira-mobile-rest";
    public static final String DESKTOP_URL_PARAMETER = "desktop";
    private static final List<String> EXCLUDED_PREFIXES = Arrays.asList("/download/", "/rest/", "/plugins/servlet/mobile");
    private static final Pattern MOBILE_USER_AGENT_REGEX = Pattern.compile("(iPhone;|iPhone Simulator;|iPod;|iPod touch;|Linux;(?: U;)? Android)");
    private static final Pattern ANDROID_CHROME = Pattern.compile("Chrome/[.\\d]* Mobile");
    private static final Pattern OLD_ANDROID = Pattern.compile("Linux;(?: U;)? Android (?:[23]\\.\\d|4\\.0\\.[12])");
    private static final UserAgentUtilImpl USER_AGENT_UTIL = new UserAgentUtilImpl();

    public static boolean isMobileViewRequest(HttpServletRequest request) {
        return MobileUtils.isSupportedUserAgent(request) && !MobileUtils.isDesktopSwitchRequired(request) && !MobileUtils.isExcludedFromMobileTransformation(request);
    }

    public static boolean isExcludedFromMobileTransformation(HttpServletRequest request) {
        for (String prefix : EXCLUDED_PREFIXES) {
            if (!request.getRequestURI().startsWith(request.getContextPath() + prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSupportedUserAgent(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent");
        if (StringUtils.isBlank((CharSequence)userAgent)) {
            return false;
        }
        return ANDROID_CHROME.matcher(userAgent).find() || MOBILE_USER_AGENT_REGEX.matcher(userAgent).find() && !OLD_ANDROID.matcher(userAgent).find();
    }

    public static boolean isDesktopSwitchRequired(HttpServletRequest request) {
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                if (!"jira.mobile.desktop.switch".equals(cookie.getName()) || !"true".equals(cookie.getValue())) continue;
                return true;
            }
        }
        return Boolean.valueOf(request.getParameter(DESKTOP_URL_PARAMETER));
    }

    public static UserAgentUtil.OperatingSystem getOperatingSystem(HttpServletRequest request) {
        String userAgent = request.getHeader("USER-AGENT");
        UserAgentUtil.UserAgent userAgentInfo = USER_AGENT_UTIL.getUserAgentInfo(userAgent);
        return userAgentInfo.getOperatingSystem();
    }

    public static boolean shouldShowOpenAppButton(ApplicationUser user, UserAgentUtil.OperatingSystem os, boolean isMobilePluginEnabled) {
        return user != null && MobileUtils.isAndroidOrIOS(os) && isMobilePluginEnabled;
    }

    private static boolean isAndroidOrIOS(UserAgentUtil.OperatingSystem os) {
        UserAgentUtil.OperatingSystem.OperatingSystemFamily osFamily = os.getOperatingSystemFamily();
        return osFamily == UserAgentUtil.OperatingSystem.OperatingSystemFamily.ANDROID || osFamily == UserAgentUtil.OperatingSystem.OperatingSystemFamily.IPAD || osFamily == UserAgentUtil.OperatingSystem.OperatingSystemFamily.IPHONE;
    }
}

