define('util/scroll-tops', ['zepto'], function ($) {

    let tops = {};

    const SCROLL_DEAD_ZONE = 80;

//    AtlassianMobile.Scrolling = {
    const Scrolling = {
        savePosition: function () {
            tops[window.location.hash] = document.body.scrollTop;
        },

        restorePosition: function () {
            const scrollTop = tops[window.location.hash];
            if (scrollTop) {
                // Only scroll if they have scrolled out of the deadzone
                if (scrollTop > SCROLL_DEAD_ZONE) {
                    setTimeout(function () {
                        window.scroll(0, +scrollTop);
                    }, 0);
                } else {
                    setTimeout(function () {
                        window.scroll(0, 1);
                    }, 0);
                }
            }
        },

        hasSavedPosition: function () {
            return tops.hasOwnProperty(window.location.hash);
        },

        resetCurrentHash: function () {
            delete tops[window.location.hash];
        },

        resetByHash: function (hash) {
            delete tops[hash];
        },

        resetAll: function () {
            tops = {};
        }
    };

    return Scrolling;
});

