/*
 * This object provides convenient access to the value of META tags in the document.
 * However, it also maintains a Javascript store of key and values over and above any document META tags so
 * is a convenient repository of data that is required application wide.
 */
define('util/app-data', ['zepto', 'exports'], function ($, exports) {

    let undefined;
    const AppData = {

        objectCache: {},

        /**
         * If a key is found in the store this will be used in preference to the META tags of the page.
         */
        store: {},

        get: function (key) {
            let value = this.store[key];
            if (value !== undefined) {
                return value;
            }

            let $meta = $("meta[name='" + key + "']");
            if ($meta.length == 0) {
                $meta = $("meta[name='ajs-" + key + "']");
            }

            if ($meta.length) {
                value = $meta.attr("content");
                this.put(key, value);
            }
            return value;
        },

        getBoolean: function (key) {
            return this.get(key) == "true";
        },

        /**
         * Special case as "getUsername" is more intuitive than "get('remote-user')"
         */
        getUsername: function () {
            return this.get('remote-user');
        },

        /**
         * Retrieve a JSON encoded value and return it as an Object. The first time a key is requested its deserialised form
         * is cached for subsequent requests.
         *
         * @param key the key of the JSON encoded Object
         * @return the decoded Object or undefined if no JSON Object is found for the key
         */
        getObject: function(key) {
            if (!this.objectCache[key]) {
                const objStr = this.get(key);
                let obj = undefined;
                if (objStr && objStr.length) {
                    try {
                        obj = JSON.parse(objStr);
                    } catch (err) {

                    }
                }

                this.objectCache[key] = obj;
            }

            return this.objectCache[key];
        },

        put: function(key, value) {
            this.store[key] = value;
        }
    };

    $.extend(exports, AppData);
});
