define('layout/fly-out/fly-out-main',
    ['zepto', 'layout/fly-out/fly-out-view', 'util/events', 'util/hide-address-bar', 'require'],
    function ($, FlyOutView, events, hideAddressBar, require) {

        const $innerContainer = $("#inner-container"), $flyOut = $(".fly-out.left");

        const leftFlyout = new FlyOutView({
            el: $flyOut,
            onAnimationFinished: function() {
                hideAddressBar();
            }
        });

        events.router.on('change', function () {
            leftFlyout.hide();
        });

        // Going old school to bind the listener to the capture phase of the event, rather than the bubble phase
        // This is to prevent strange event ordering in some Androids: JMOB-303
        $innerContainer[0].addEventListener('click', function (event) {
            if (!leftFlyout.isVisible()) {
                return;
            }

            leftFlyout.hide(); // clicking anywhere in the inner container should close the flyout

            event.preventDefault();
            if ($.os.android) {
                event.stopPropagation();
            }
        }, true);

        $flyOut.on('click', 'a:not(.redirect)', function (e) {
            leftFlyout.hide();
            // Make sure clicking the menu item for the current page refreshes the page
            if (this.href == location.href) {
                require('util/router').presenter.refreshCurrentView();
            }
        });

        return leftFlyout;
    });

