define('feature/issues/fields/main-fields-view', ['../issue.soy', 'zepto', 'backbone', 'util/app-data'], function (Templates, $, Backbone, appData) {
    return Backbone.View.extend({
        className: 'main-fields',

        initialize: function (options) {
            this.listenTo(this.model, 'change:fields', this.render);
            this.jiraURL = appData.get('context-path') + '/browse/' + this.model.get('key');
        },

        render: function () {
            this.$el.html(Templates.drawMainFields({
                issue: this.model.attributes,
                keyUrl: this.jiraURL
            }));
            return this;
        }
    });
});
