define('feature/issues/comments/single-comment-view', ['./comments.css', './single-comment.soy', 'zepto', 'backbone', 'util/misc'], function (css, Templates, $, Backbone, utils) {
    return Backbone.View.extend({
        className: 'comment-container no-flicker',

        initialize: function (options) {
            this.commentData = this.model.attributes;
            this.stippedCommentData = utils.stripHTML(this.model.attributes.body);
        },

        events: {
            'click .comment-container': 'toggleComment'
        },

        render: function () {
            if(this.model.expand) {
                this.$el.html(Templates.drawComment({
                    comment: this.commentData,
                    selected: this.model.selected
                }));
            } else {
                this.$el.html(Templates.drawCommentPreview({
                    comment: this.model.attributes,
                    cleanComment: this.stippedCommentData
                }));
            }

            return this;
        },

        toggleComment: function(e) {
            const $target = $(e.target);
            // If the user clicked on a link, don't collapse
            if ( !$target.closest('a, .comment-container').hasClass('comment-container') || $target.closest('img').length ) {
                return;
            }

            this.model.expand = !this.model.expand;
            this.model.selected = false;
            this.render();
        }
    });
});
