define('feature/issue-lists/issue-list-view',
    [
        './issue-list.less',
        './issue-list.soy',
        '../../layout/base/base.soy',
        'layout/base/page-view',
        'layout/header/header-view',
        'layout/loading-overlay/loading-overlay-view',
        'feature/issue-lists/issue-list-item-view',
        'feature/open-app-button/open-app-button',
        'util/app-data',
        'util/events',
        'underscore',
        'require'
    ],
    function (css, Templates, BaseTemplates, PageView, HeaderView, LoadingOverlayView, IssueListItemView, OpenAppButtonView, appData, events, _, require) {
        require('widget/jquery-spinner/jquery-spinner');
        require('@atlassian/aui/entry/aui.component.message'); // needed for .listContainer template
        const escapeHtml = require('@atlassian/aui/entry/behaviours/aui.behaviour.escape-html').escapeHtml;

        const IssueListView = PageView.extend({
            MAX_SHOW_MORE_INCREMENT: 20,   //can set a default in common list view
            SHOW_MORE_THRESHOLD: 24,    //number of issues that won't require a show more button, can set a default in common list view
            className: 'card issue-list-card',

            events: {
                'click .list-title-refresh button': 'refresh',
                'click .show-more-button': 'showMore'
            },

            desktopUrl: function () {
                let url = '/issues/?';
                if ( !this.options.filterId && !this.options.jql ) {
                    url += 'jql='
                } else {
                    if (this.options.filterId) {
                        url += 'filter=' + encodeURIComponent(this.options.filterId) + '&';
                    }
                    if (this.options.jql) {
                        url += 'jql=' + encodeURIComponent(this.options.jql);
                    }
                }
                return appData.get('context-path') + url;
            },

            pageTitle: function () {
                return '[' + this.title + ']';
            },

            initialize: function (options) {
                this.title = options.title;
                this.isList = true;
                this.childViews = [];
                this.listenTo(this.collection, 'reset', this.render);
                this.listenTo(this.collection, 'add', this.addListItem); //This might be a candidate for COMMON CODE
                this.listenTo(this.collection, 'showMoreComplete', this.hideShowMoreLoading); //This might be a candidate for COMMON CODE

                // Initialise the header
                const headerAttributes = {
                    el: this.$el,
                    title: this.title,
                    action: false
                };
                this.header = new HeaderView(headerAttributes);
                this.loadingOverlay = new LoadingOverlayView();

                this.openAppButton = new OpenAppButtonView({
                    page: 'filters'
                });
            },

            render: function () {
                this.$el.empty();
                this.header.render();
                this.loadingOverlay.render();

                // Render content
                const options = {
                    title: this.title,
                    issues: this.collection.toJSON()
                };
                if (this.options.error) {
                    options.error = escapeHtml(this.options.error);
                }
                this.$el.append(Templates.listContainer(options));

                const $list = this.$('.issue-list');
                var issues = this.collection;
                const childViews = [];

                const isOverThreshold = issues.listTotalLength > this.SHOW_MORE_THRESHOLD;
                const isListAtEnd = issues.startAt >= issues.listTotalLength;

                if (!issues.isEmpty()) {
                    issues.each(function (issue) {
                        const view = new IssueListItemView({model: issue});
                        childViews.push(view);
                        view.render();
                        $list.append(view.$el);
                    });
                }
                this.childViews.concat(childViews);

                if (isOverThreshold && !isListAtEnd) {
                    this.$el.find(".show-more-button-container").html(Templates.showMoreContainer({
                        numOfItems: this.showMoreIncrement(this.MAX_SHOW_MORE_INCREMENT)
                    }));
                } else {
                    if (!isListAtEnd) {
                        this.collection.getMore(this.collection.listTotalLength);
                    }
                    this.$el.find(".show-more-button-container").remove();
                }

                this.$el.append(BaseTemplates.atlasFooter());

                this.openAppButton.render();
            },

            refresh: function () {
                require('util/presenter').refreshCurrentView();
            },

            //THESE SHOULD BE ADDED TO A COMMON LIST VIEW

            //The number of extra issues the show more button for this list view search for.
            showMoreIncrement: function(maxIncrement){
                const totalRemaining = this.collection.listTotalLength - this.collection.length;
                return totalRemaining >= maxIncrement ? maxIncrement : totalRemaining;
            },

            showMoreLoading: function(){
                const $buttonContainer = this.$('.show-more-button-container');
                $buttonContainer.find('.container-more').addClass('hidden');
                $buttonContainer.find('.container-loading').removeClass('hidden');
                $buttonContainer.find('.loading-spinner').spin('small', {
                    left: 0,
                    top: "auto"
                });
            },

            hideShowMoreLoading: function() {
                const $buttonContainer = this.$('.show-more-button-container');
                if (this.collection.length < this.collection.listTotalLength) {
                    $buttonContainer.html(Templates.showMoreContainer({
                        numOfItems: this.showMoreIncrement(this.MAX_SHOW_MORE_INCREMENT)
                    }));
                } else {
                    $buttonContainer.remove();
                }

            },

            showMore: function() {
               this.showMoreLoading();
               this.collection.getMore(this.showMoreIncrement(this.MAX_SHOW_MORE_INCREMENT));
            },

            addListItem: function(issue){
                const view = new IssueListItemView({model: issue});
                this.childViews.push(view);
                view.render();
                this.$('.issue-list').append(view.$el);
            },

            //END COMMON CODE
            onClose: function(){
                _.each(this.childViews, function (view){
                    view.close();
                });
            }
        });

        return IssueListView;
    }
);
