define('feature/issue-lists/issue-list-item-view', ['./issue-list.less', './issue-list.soy', 'backbone', 'util/router'], function (css, Templates, Backbone, router) {
    const IssueListItemView = Backbone.View.extend({
        tagName: 'li',
        className: 'issue-entry',

        events: {
            'click': 'gotoIssue'
        },

        render: function () {
            this.$el.html(Templates.listEntry({
                issue: this.model.toJSON()
            }));
        },

        gotoIssue: function () {
            router.navigate('issue/' + this.model.get('key'), {trigger: true});
        }
    });

    return IssueListItemView;
});
