(function() {
    var contextPath = AJS.contextPath();

    // Shows the switch to desktop banner and binds the click event
    function displayBanner() {
        var header = jQuery('header#header');
        // Draw if it isn't already drawn
        if(header.find('#jmob-switch').length === 0) {
            header.prepend(AtlassianMobile.Templates.JIRA.Headsup.switchNotice());
        }
        // Always rebind
        header.find('#jmob-switch').click(function() {
           var path = contextPath;
           if (!path) {
               path = "/";
           }
            document.cookie= 'jira.mobile.desktop.switch=null; path=' + path;
            // Check if it's KA
            var url = location.href;
            var index = url.indexOf(contextPath + '/i#')
            if (index !== -1) {
                window.location.href = contextPath + '/' + url.substring(index + contextPath.length + 3);
            } else {
                location.reload();
            }
        });
    }

    // Document complete
    jQuery(displayBanner);
    // JIRA content added event
    JIRA.bind(JIRA.Events.NEW_CONTENT_ADDED, function(e, context, reason) {
        displayBanner();
    });
}());
