/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.simplified.mode.service;

import com.atlassian.jira.mobile.simplified.mode.service.SimplifiedModeTemplateRenderer;
import com.atlassian.jira.mobile.utils.UrlUtilService;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SimplifiedModeViewService {
    private static final Logger log = LoggerFactory.getLogger(SimplifiedModeViewService.class);
    private final List<SimplifiedModeTemplateRenderer> renderers;
    private final UrlUtilService urlUtilService;

    public boolean renderSimpleView(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String url = request.getRequestURI();
        String context = request.getContextPath();
        String path = url.substring(context.length());
        try {
            SimplifiedModeTemplateRenderer renderer = this.getRenderer(path);
            if (renderer == null) {
                return false;
            }
            String canonicalUrl = this.urlUtilService.getCanonicalUrl(request);
            this.writeResponse(response, renderer.renderPage(request, canonicalUrl), 200);
            return true;
        }
        catch (Exception e) {
            log.error("Error occurred. ", (Throwable)e);
            return false;
        }
    }

    private SimplifiedModeTemplateRenderer getRenderer(String path) {
        for (SimplifiedModeTemplateRenderer renderer : this.renderers) {
            if (!renderer.matches(path)) continue;
            return renderer;
        }
        return null;
    }

    private void writeResponse(HttpServletResponse response, String html, int statusCode) throws IOException {
        response.setStatus(statusCode);
        response.getWriter().append(html);
    }

    @Autowired
    public SimplifiedModeViewService(List<SimplifiedModeTemplateRenderer> renderers, UrlUtilService urlUtilService) {
        this.renderers = renderers;
        this.urlUtilService = urlUtilService;
    }
}

