/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.simplified.mode.service;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.mobile.simplified.mode.config.DefaultJiraFilters;
import com.atlassian.jira.mobile.simplified.mode.service.SimplifiedModeBaseRenderer;
import com.atlassian.jira.mobile.simplified.mode.service.SimplifiedModeTemplateRenderer;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class ListJiraIssuesSimplifiedModeRenderer
implements SimplifiedModeTemplateRenderer {
    private static final Logger log = LoggerFactory.getLogger(ListJiraIssuesSimplifiedModeRenderer.class);
    private static final Pattern ISSUES_LIST_URL_PATTERN = Pattern.compile("^\\/issues\\/");
    private static final String PAGE_QUERY_PATTERN_STR = "&page=\\d+(?!=$|&)";
    private static final String ISSUE_LIST_TEMPLATE_NAME = "AtlassianMobile.SimplifiedMode.Templates.JIRA.IssueList.listContainer";
    private static final String ISSUE_LIST_RESOURCE_NAME = "com.atlassian.jira.mobile:view-issue-list-resources-simplified-mode";
    private static final int PAGE_ISSUES_LIMIT = 20;
    private final SearchService searchService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final DefaultJiraFilters defaultJiraFilters;
    private final SimplifiedModeBaseRenderer simplifiedModeBaseRenderer;
    private final SearchRequestService searchRequestService;

    @Autowired
    public ListJiraIssuesSimplifiedModeRenderer(SearchService searchService, JiraAuthenticationContext jiraAuthenticationContext, DefaultJiraFilters defaultJiraFilters, SearchRequestService searchRequestService, SimplifiedModeBaseRenderer simplifiedModeBaseRenderer) {
        this.searchService = searchService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.defaultJiraFilters = defaultJiraFilters;
        this.simplifiedModeBaseRenderer = simplifiedModeBaseRenderer;
        this.searchRequestService = searchRequestService;
    }

    @Override
    public boolean matches(String path) {
        return ISSUES_LIST_URL_PATTERN.matcher(path).matches();
    }

    @Override
    public String renderPage(HttpServletRequest request, String canonicalUrl) {
        String pageTitle;
        Query query;
        int pageNumber = this.getPageNumber(request);
        long filterId = this.getFilterId(request);
        if (filterId < 0L) {
            query = this.defaultJiraFilters.getQueryById(filterId);
            pageTitle = this.defaultJiraFilters.getTitleById(filterId);
        } else {
            SearchRequest filter = this.getSearchRequest(filterId);
            query = filter.getQuery();
            pageTitle = filter.getName();
        }
        SearchResults<Issue> searchResults = this.searchForIssuesByQuery(query, pageNumber);
        List issues = searchResults.getResults();
        int issuesTotal = searchResults.getTotal();
        Map<String, Object> context = this.getTemplateRenderContext(request, issues, pageTitle, issuesTotal, pageNumber);
        SimplifiedModeBaseRenderer.BaseRenderViewParams baseRenderViewParams = new SimplifiedModeBaseRenderer.BaseRenderViewParams(pageTitle, canonicalUrl);
        return this.simplifiedModeBaseRenderer.renderTemplate(ISSUE_LIST_RESOURCE_NAME, ISSUE_LIST_TEMPLATE_NAME, baseRenderViewParams, context);
    }

    private SearchRequest getSearchRequest(long filterId) {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(loggedInUser);
        return this.searchRequestService.getFilter((JiraServiceContext)serviceContext, Long.valueOf(filterId));
    }

    private long getFilterId(HttpServletRequest request) {
        String filterIdString = request.getParameter("filter");
        if (filterIdString == null || filterIdString.isEmpty()) {
            return Long.MIN_VALUE;
        }
        ListJiraIssuesSimplifiedModeRenderer.checkIsNumber(filterIdString, String.format("Filter id is not specified correctly: %s", filterIdString));
        return Long.parseLong(filterIdString);
    }

    private SearchResults<Issue> searchForIssuesByQuery(Query query, int pageNumber) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        String jqlQueryString = this.searchService.getJqlString(query);
        log.debug("query: {}", (Object)jqlQueryString);
        return this.searchService.search(user, query, PagerFilter.newPageAlignedFilter((int)((pageNumber - 1) * 20), (int)20));
    }

    private Map<String, Object> getTemplateRenderContext(HttpServletRequest request, List<Issue> issues, String title, int issuesTotal, int pageNumber) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("title", title);
        context.put("issues", issues);
        context.put("issuePath", request.getContextPath() + "/browse/");
        int pagesTotal = (int)Math.ceil((double)issuesTotal / 20.0);
        if (pagesTotal > 1) {
            context.put("currentPage", pageNumber);
            String pageURL = String.format("%s?%s", request.getRequestURL(), request.getQueryString().replaceAll(PAGE_QUERY_PATTERN_STR, ""));
            context.put("pageURL", pageURL);
            List<Long> pageNumbers = this.getPageNumbersToView(pageNumber, pagesTotal);
            context.put("pageNumbers", pageNumbers);
            context.put("pagesSize", pageNumbers.size());
        }
        return context;
    }

    private int getPageNumber(HttpServletRequest request) {
        String pageNumberString = request.getParameter("page");
        if (pageNumberString == null) {
            return 1;
        }
        ListJiraIssuesSimplifiedModeRenderer.checkIsNumber(pageNumberString, String.format("Page number is not specified correctly: %s", pageNumberString));
        int pageNumber = Integer.parseInt(pageNumberString);
        if (pageNumber < 1) {
            throw new IllegalArgumentException("Invalid page number specified.");
        }
        return pageNumber;
    }

    private List<Long> getPageNumbersToView(int currentPageNumber, int pagesInTotal) {
        long lastPageNumberInRange;
        long firstPageNumberInRange = currentPageNumber - 2;
        if (firstPageNumberInRange < 1L) {
            firstPageNumberInRange = 1L;
        }
        if ((lastPageNumberInRange = (long)(currentPageNumber + 2)) > (long)pagesInTotal) {
            lastPageNumberInRange = pagesInTotal;
        }
        return LongStream.range(firstPageNumberInRange, lastPageNumberInRange + 1L).boxed().collect(Collectors.toList());
    }

    private static void checkIsNumber(String num, String message) {
        if (StringUtils.isBlank((String)num) || !NumberUtils.isNumber((String)num)) {
            throw new IllegalArgumentException(message);
        }
    }
}

