/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.servlet.filter.mapper;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestStore;
import com.atlassian.jira.mobile.service.FeatureFlagService;
import com.atlassian.jira.mobile.servlet.filter.mapper.URLTracker;
import com.atlassian.jira.mobile.simplified.mode.config.DefaultJiraFilters;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.JiraUrlCodec;
import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class IssueNavURLTracker
implements URLTracker {
    private static final Pattern PATTERN = Pattern.compile("^\\/issues\\/");
    private final FeatureFlagService featureFlagService;
    private final DefaultJiraFilters defaultJiraFilters;
    private SearchRequestStore searchRequestStore;
    private ShareManager shareManager;

    @Override
    public boolean matches(String path) {
        return PATTERN.matcher(path).matches();
    }

    @Override
    public String map(String path, HttpServletRequest request) throws UnsupportedEncodingException {
        if (this.matches(path)) {
            String jql = request.getParameter("jql");
            String filterId = request.getParameter("filter");
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotBlank((String)jql)) {
                sb.append("filter/jql/").append(JiraUrlCodec.encode((String)jql, (String)"UTF-8", (boolean)true));
                if (StringUtils.isNotBlank((String)filterId)) {
                    sb.append("/").append(JiraUrlCodec.encode((String)filterId, (String)"UTF-8", (boolean)true));
                }
            } else if (StringUtils.isNotBlank((String)filterId)) {
                long filterIdNumber = Long.parseLong(filterId);
                if (filterIdNumber == -1L) {
                    sb.append("filter/assigned");
                } else if (filterIdNumber == -2L) {
                    sb.append("filter/reported");
                } else if (filterIdNumber == -3L) {
                    sb.append("filter/recent");
                } else if (filterIdNumber == -4L) {
                    sb.append("filter/all");
                } else {
                    sb.append("filter/").append(JiraUrlCodec.encode((String)filterId, (String)"UTF-8", (boolean)true));
                }
            } else {
                sb.append("filter/all");
            }
            return sb.toString();
        }
        return null;
    }

    @Override
    public boolean requiresLogin(String path, HttpServletRequest request, ApplicationUser user) {
        String rawFilterId;
        if (this.matches(path) && user == null && StringUtils.isNotBlank((String)(rawFilterId = request.getParameter("filter")))) {
            try {
                long filterId = Long.parseLong(rawFilterId);
                if (!this.isLoginRequiredForFilter(filterId)) {
                    return false;
                }
                if (filterId >= 0L) {
                    SearchRequest searchRequest = this.getSearchRequestStore().getSearchRequest(Long.valueOf(filterId));
                    return !this.getShareManager().isSharedWith(user, (SharedEntity)searchRequest);
                }
            }
            catch (NumberFormatException e) {
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean isLoginRequiredForFilter(long filterId) {
        return this.featureFlagService.isSimplifiedModeEnabled() ? !this.defaultJiraFilters.isFilterPubliclyAvailable(filterId) : filterId != -4L && filterId != -3L;
    }

    private ShareManager getShareManager() {
        if (this.shareManager == null) {
            this.shareManager = (ShareManager)ComponentAccessor.getComponent(ShareManager.class);
            return this.shareManager;
        }
        return this.shareManager;
    }

    private SearchRequestStore getSearchRequestStore() {
        if (this.searchRequestStore == null) {
            this.searchRequestStore = (SearchRequestStore)ComponentAccessor.getComponent(SearchRequestStore.class);
            return this.searchRequestStore;
        }
        return this.searchRequestStore;
    }

    public IssueNavURLTracker(FeatureFlagService featureFlagService, DefaultJiraFilters defaultJiraFilters) {
        this.featureFlagService = featureFlagService;
        this.defaultJiraFilters = defaultJiraFilters;
    }
}

