/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.servlet.filter;

import com.atlassian.jira.mobile.service.FeatureFlagService;
import com.atlassian.jira.mobile.servlet.filter.mapper.MobileURLTrackerService;
import com.atlassian.jira.mobile.utils.MobileUtils;
import com.atlassian.plugin.webresource.WebResourceManager;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class DesktopSwitchFilter
implements Filter {
    private final MobileURLTrackerService mobileURLTrackerService;
    private final WebResourceManager webResourceManager;
    private final FeatureFlagService featureFlagService;

    public DesktopSwitchFilter(MobileURLTrackerService mobileURLTrackerService, WebResourceManager webResourceManager, FeatureFlagService featureFlagService) {
        this.mobileURLTrackerService = mobileURLTrackerService;
        this.webResourceManager = webResourceManager;
        this.featureFlagService = featureFlagService;
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (this.shouldShowBanner(request)) {
            this.webResourceManager.requireResource("com.atlassian.jira.mobile:mobile-headsup");
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private boolean shouldShowBanner(HttpServletRequest request) {
        boolean isCorrectDevice = MobileUtils.isSupportedUserAgent(request);
        String url = request.getRequestURI();
        String context = request.getContextPath();
        String path = url.substring(context.length());
        boolean isCorrectPage = this.mobileURLTrackerService.matchesPath(path);
        return !this.featureFlagService.isSimplifiedModeEnabled() && isCorrectDevice && isCorrectPage;
    }
}

