/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.rest.fields;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.ProjectSystemField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinksBeanBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinksBeanBuilderFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueRefJsonBean;
import com.atlassian.jira.mobile.rest.fields.MobileIssueBean;
import com.atlassian.jira.mobile.rest.fields.ViewScreenBean;
import com.atlassian.jira.mobile.rest.util.MobileBeanBuilderFactory;
import com.atlassian.jira.rest.v2.issue.EditMetaBean;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.jira.rest.v2.issue.IssueResource;
import com.atlassian.jira.rest.v2.issue.ResourceUriBuilder;
import com.atlassian.jira.rest.v2.issue.TransitionBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.sun.jersey.api.uri.UriBuilderImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobileIssueBeanBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(MobileIssueBeanBuilder.class);
    private final FieldLayoutManager fieldLayoutManager;
    private final FieldManager fieldManager;
    private final ResourceUriBuilder resourceUriBuilder;
    private final MobileBeanBuilderFactory beanBuilderFactory;
    private final IssueLinksBeanBuilderFactory issueLinkBeanBuilderFactory;
    private final IssueWorkflowManager issueWorkflowManager;
    private IncludedFields fieldsToInclude;
    private String expand;
    private UriBuilder uriBuilder;
    private final Issue issue;
    private final ApplicationUser loggedInUser;

    @Deprecated
    public MobileIssueBeanBuilder(FieldLayoutManager fieldLayoutManager, JiraAuthenticationContext authContext, FieldManager fieldManager, MobileBeanBuilderFactory beanBuilderFactory, Issue issue, IncludedFields fieldsToInclude, IssueLinksBeanBuilderFactory issueLinkBeanBuilderFactory, IssueWorkflowManager issueWorkflowManager, ApplicationUser loggedInUser) {
        this(fieldLayoutManager, fieldManager, beanBuilderFactory, issue, fieldsToInclude, issueLinkBeanBuilderFactory, issueWorkflowManager, loggedInUser);
    }

    public MobileIssueBeanBuilder(FieldLayoutManager fieldLayoutManager, FieldManager fieldManager, MobileBeanBuilderFactory beanBuilderFactory, Issue issue, IncludedFields fieldsToInclude, IssueLinksBeanBuilderFactory issueLinkBeanBuilderFactory, IssueWorkflowManager issueWorkflowManager, ApplicationUser loggedInUser) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.fieldManager = fieldManager;
        this.resourceUriBuilder = new ResourceUriBuilder();
        this.beanBuilderFactory = beanBuilderFactory;
        this.issue = issue;
        this.fieldsToInclude = fieldsToInclude;
        this.issueLinkBeanBuilderFactory = issueLinkBeanBuilderFactory;
        this.issueWorkflowManager = issueWorkflowManager;
        this.uriBuilder = new UriBuilderImpl();
        this.loggedInUser = loggedInUser;
    }

    public MobileIssueBeanBuilder expand(String expand) {
        this.expand = expand;
        return this;
    }

    public IssueBean build() {
        MobileIssueBean bean = new MobileIssueBean(this.issue.getId(), this.issue.getKey(), this.resourceUriBuilder.build(this.uriBuilder, IssueResource.class, String.valueOf(this.issue.getId())));
        bean.fieldsToInclude(this.fieldsToInclude);
        this.addFields(this.issue, bean);
        this.addParentLink(this.issue, bean);
        this.addTransitions(this.issue, bean);
        if (this.expand != null && this.expand.contains("editmeta")) {
            EditMetaBean editmeta = this.beanBuilderFactory.getEditMetaBeanBuilder().issue(this.issue).fieldsToInclude(this.fieldsToInclude).build();
            bean.editmeta(editmeta);
        }
        if (this.expand != null && this.expand.contains("changelog")) {
            bean.changelog(this.beanBuilderFactory.getChangelogBeanBuilder().build(this.issue));
        }
        if (this.expand != null && this.expand.contains("screen")) {
            List<ViewScreenBean> map = this.beanBuilderFactory.getViewScreenBeanBuilder().getViewScreen(this.issue);
            bean.setScreen(map);
        }
        bean.setPermissions(this.beanBuilderFactory.getPermissionBeanBuilder().build(this.loggedInUser, this.issue));
        bean.setAddCommentMeta(this.beanBuilderFactory.getAddCommentMetaBeanBuilder().build(this.loggedInUser, this.issue));
        return bean;
    }

    private void addTransitions(Issue issue, IssueBean bean) {
        if (this.isIncludeTransitions()) {
            List sortedAvailableActions = this.issueWorkflowManager.getSortedAvailableActions(issue);
            ArrayList<TransitionBean> transitionBeans = new ArrayList<TransitionBean>();
            for (ActionDescriptor action : sortedAvailableActions) {
                TransitionBean transitionMetaBean = this.beanBuilderFactory.getTransitionMetaBeanBuilder().issue(issue).action(action).build();
                transitionBeans.add(transitionMetaBean);
            }
            bean.setTransitionBeans(transitionBeans);
        }
    }

    private void addOpsbar(Issue issue, IssueBean bean) {
    }

    private void addParentLink(Issue issue, IssueBean bean) {
        IssueLinksBeanBuilder builder = this.issueLinkBeanBuilderFactory.newIssueLinksBeanBuilder(issue);
        IssueRefJsonBean parentLink = builder.buildParentLink();
        if (parentLink != null) {
            bean.addParentField(parentLink, this.getI18nBean(this.loggedInUser).getText("issue.field.parent"));
        }
    }

    private void addFields(Issue issue, IssueBean bean) {
        boolean includeRenderableFields = this.isIncludeRenderableFields();
        FieldLayout layout = this.fieldLayoutManager.getFieldLayout(issue);
        List fieldLayoutItems = layout.getVisibleLayoutItems(this.loggedInUser, issue.getProjectObject(), CollectionBuilder.list((Object[])new String[]{issue.getIssueTypeObject().getId()}));
        for (FieldLayoutItem fieldLayoutItem : fieldLayoutItems) {
            OrderableField field = fieldLayoutItem.getOrderableField();
            FieldJsonRepresentation fieldValue = this.getFieldValue(fieldLayoutItem, issue);
            if (fieldValue == null || fieldValue.getStandardData() == null) continue;
            bean.addField((Field)field, fieldValue, includeRenderableFields);
        }
        try {
            Set fields = this.fieldManager.getAvailableNavigableFields(this.loggedInUser);
            for (OrderableField field : fields) {
                if (bean.hasField(field.getId()) || field instanceof OrderableField && !this.isSpecialField((NavigableField)field) || !(field instanceof RestAwareField)) continue;
                this.addRestAwareField(issue, bean, (Field)field, (RestAwareField)field);
            }
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    private boolean isSpecialField(NavigableField field) {
        return field instanceof ProjectSystemField;
    }

    private void addRestAwareField(Issue issue, IssueBean bean, Field field, RestAwareField restAware) {
        boolean includeRenderableFields = this.isIncludeRenderableFields();
        FieldJsonRepresentation fieldJsonFromIssue = restAware.getJsonFromIssue(issue, includeRenderableFields, null);
        if (fieldJsonFromIssue != null && fieldJsonFromIssue.getStandardData() != null) {
            bean.addField(field, fieldJsonFromIssue, includeRenderableFields);
        }
    }

    private boolean isIncludeRenderableFields() {
        return this.expand != null && this.expand.contains("renderedFields");
    }

    private boolean isIncludeTransitions() {
        return this.expand != null && this.expand.contains("transitions");
    }

    private boolean isIncludeOpsbar() {
        return this.expand != null && this.expand.contains("operations");
    }

    FieldJsonRepresentation getFieldValue(FieldLayoutItem fieldLayoutItem, Issue issue) {
        OrderableField field = fieldLayoutItem.getOrderableField();
        if (field instanceof RestAwareField) {
            RestAwareField restAware = (RestAwareField)field;
            return restAware.getJsonFromIssue(issue, this.isIncludeRenderableFields(), fieldLayoutItem);
        }
        LOG.info(String.format("OrderableField %s not rendered in JSON", field.getId()));
        return null;
    }

    private I18nHelper getI18nBean(ApplicationUser remoteUser) {
        return ComponentAccessor.getI18nHelperFactory().getInstance(remoteUser);
    }
}

