/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.resource.manager;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.webresource.JavascriptWebResource;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerFactory;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MobileWebResourceManager {
    private static final String MOBILE_WRM_REQUEST_LOCAL_KEY = "plugin.webresource.required.resources.jiramobile";
    private final WebResourceAssembler staticAssembler;
    private final WebResourceIntegration webResourceIntegration;
    private final WebResourceUrlProvider webResourceUrlProvider;

    @Autowired
    public MobileWebResourceManager(WebResourceIntegration webResourceIntegration, WebResourceAssemblerFactory webResourceAssemblerFactory, WebResourceUrlProvider webResourceUrlProvider) {
        this.webResourceIntegration = webResourceIntegration;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.staticAssembler = webResourceAssemblerFactory.create().includeSuperbatchResources(false).build();
    }

    public Boolean isAnalyticsInstalled() {
        String moduleCompleteKey = "com.atlassian.analytics.analytics-client:js-events";
        ModuleDescriptor moduleDescriptor = this.webResourceIntegration.getPluginAccessor().getEnabledPluginModule(moduleCompleteKey);
        return moduleDescriptor != null;
    }

    public String getAnalyticsTags() {
        if (!this.isAnalyticsInstalled().booleanValue()) {
            return "";
        }
        return this.getFilesFromWebResource("com.atlassian.analytics.analytics-client:js-events", Arrays.asList("store.js", "atlassian-analytics.js"));
    }

    public String getSoyDependenciesTags() {
        return this.getFilesFromWebResource("com.atlassian.soy.soy-template-plugin:soy-deps", Arrays.asList("soyutils.js", "atlassian-deps.js"));
    }

    private String getFilesFromWebResource(String moduleCompleteKey, List<String> jsFilenames) {
        JavascriptWebResource formatter = new JavascriptWebResource();
        StringBuilder builder = new StringBuilder();
        HashMap params = Maps.newHashMap();
        for (String filename : jsFilenames) {
            String resourceUrl = this.webResourceUrlProvider.getStaticPluginResourceUrl(moduleCompleteKey, filename, UrlMode.RELATIVE);
            builder.append(formatter.formatResource(resourceUrl, (Map)params));
        }
        return builder.toString();
    }

    public WebResourceAssembler assembler() {
        Map cache = this.webResourceIntegration.getRequestCache();
        WebResourceAssembler assembler = (WebResourceAssembler)cache.get(MOBILE_WRM_REQUEST_LOCAL_KEY);
        if (assembler == null) {
            assembler = this.constructAssembler();
            cache.put(MOBILE_WRM_REQUEST_LOCAL_KEY, assembler);
        }
        return assembler;
    }

    private WebResourceAssembler constructAssembler() {
        return this.staticAssembler.copy();
    }
}

