/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.auth;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthUrlProvider {
    private static final Logger log = LoggerFactory.getLogger(AuthUrlProvider.class);
    private static final URI ROOT_PATH = URI.create("/");
    private final ApplicationProperties appProps;
    private final LoginUriProvider loginUriProvider;

    @Autowired
    public AuthUrlProvider(ApplicationProperties appProps, LoginUriProvider loginUriProvider) {
        this.appProps = appProps;
        this.loginUriProvider = loginUriProvider;
    }

    public String getLoginUrl(HttpServletRequest request) {
        return this.getLoginUrl(null, request);
    }

    public String getLoginUrl(String redirectTo, HttpServletRequest request) {
        URI redirectUri = this.getRedirectUri(redirectTo, request);
        URI rawLoginUri = this.loginUriProvider.getLoginUri(redirectUri);
        URI loginUri = this.processUri(rawLoginUri, request);
        return this.normalizedUrlString(loginUri);
    }

    public String getLogoutUrl(HttpServletRequest request) {
        String logoutLocation = SecurityConfigFactory.getInstance().getLogoutURL();
        URI logoutUri = this.processUri(logoutLocation, request);
        return this.normalizedUrlString(logoutUri);
    }

    @VisibleForTesting
    URI getRedirectUri(String redirectTo, HttpServletRequest request) {
        URI instanceRootUri = URI.create(this.appProps.getBaseUrl(UrlMode.ABSOLUTE));
        URI redirectUri = this.processUri(redirectTo, request);
        if (redirectUri.isAbsolute()) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Redirection URI '{}' is absolute; replacing with local instance base URL to prevent open redirect", (Object)redirectUri);
                }
                redirectUri = new URI(null, null, redirectUri.getPath(), redirectUri.getQuery(), redirectUri.getFragment());
                redirectUri = this.processUri(redirectUri, request);
            }
            catch (URISyntaxException e) {
                redirectUri = instanceRootUri;
            }
        }
        redirectUri = instanceRootUri.resolve(redirectUri.toString()).normalize();
        if (log.isDebugEnabled()) {
            log.debug("Redirection URI parsed as '{}'", (Object)redirectUri);
        }
        return redirectUri;
    }

    private String normalizedUrlString(URI targetUri) {
        URI finalUri = targetUri.isAbsolute() ? targetUri : ROOT_PATH.resolve(targetUri.toString());
        return finalUri.normalize().toString();
    }

    private URI processUri(String location, HttpServletRequest request) {
        String meaningfulLocation = location == null ? request.getRequestURI() : location;
        URI locationFull = URI.create(meaningfulLocation);
        return this.processUri(locationFull, request);
    }

    private URI processUri(@Nonnull URI locationFull, HttpServletRequest request) {
        if (locationFull.isAbsolute()) {
            if (log.isDebugEnabled()) {
                log.debug("Processed URI '{}'; initial location was absolute, so returning that.");
            }
            return locationFull;
        }
        URI contextUri = URI.create(request.getContextPath());
        URI locationRelativeToContext = contextUri.relativize(locationFull);
        URI resolvedUri = ROOT_PATH.resolve(contextUri.toString() + "/" + locationRelativeToContext);
        if (log.isDebugEnabled()) {
            log.debug("Processed URI '{}'; converted from initial location '{}' relative to context '{}'", new Object[]{resolvedUri, locationFull, contextUri});
        }
        return resolvedUri;
    }
}

