/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.workflow;

import com.atlassian.jira.plugins.webhooks.workflow.TriggerWebhookFunction;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class WorkflowUtil {
    private final WorkflowManager workflowManager;

    public WorkflowUtil(@ComponentImport WorkflowManager workflowManager) {
        this.workflowManager = workflowManager;
    }

    public Set<Map<String, String>> getTransitionLinkedToWebHook(int webHookId) {
        HashSet transitions = Sets.newHashSet();
        Collection workflows = this.workflowManager.getWorkflows();
        for (JiraWorkflow workflow : workflows) {
            transitions.addAll(this.getTransitions(webHookId, workflow));
        }
        return transitions;
    }

    private Set<Map<String, String>> getTransitions(int webHookId, JiraWorkflow workflow) {
        HashSet transitions = Sets.newHashSet();
        Map actionToPostfunctionsMap = this.workflowManager.getPostFunctionsForWorkflow(workflow);
        for (Map.Entry entry : actionToPostfunctionsMap.entrySet()) {
            if (!this.isWebHookLinked(webHookId, (Collection)entry.getValue())) continue;
            transitions.add(ImmutableMap.of((Object)"workflow", (Object)workflow.getName(), (Object)"transition", (Object)((ActionDescriptor)entry.getKey()).getName()));
        }
        return transitions;
    }

    private boolean isWebHookLinked(int webHookId, Collection<FunctionDescriptor> functions) {
        return functions.stream().anyMatch(functionDescriptor -> this.isTriggerWebHookFunction((FunctionDescriptor)functionDescriptor) && this.isWebHookLinkedTo((FunctionDescriptor)functionDescriptor, webHookId));
    }

    private boolean isWebHookLinkedTo(FunctionDescriptor functionDescriptor, int webHookId) {
        return functionDescriptor.getArgs().get("field.webhookId").equals(String.valueOf(webHookId));
    }

    private boolean isTriggerWebHookFunction(FunctionDescriptor functionDescriptor) {
        return TriggerWebhookFunction.class.getName().equals(functionDescriptor.getArgs().get("class.name"));
    }
}

