/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.workflow;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.plugins.webhooks.serializer.issue.IssueBeanFactory;
import com.atlassian.jira.plugins.webhooks.serializer.user.UserBeanFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class TransitionMapper {
    private static final Logger LOG = Logger.getLogger(TransitionMapper.class);
    static final String TRANSITION_CONTEXT = "transition";
    static final String FROM_STATUS = "from_status";
    static final String TO_STATUS = "to_status";
    static final String WORKFLOW_STORE = "store";
    static final String CREATED_STEP = "createdStep";
    static final String WORKFLOW_DESCRIPTOR = "descriptor";
    static final String WORKFLOW_ID = "workflowId";
    static final String WORKFLOW_NAME = "workflowName";
    static final String TRANSITION_ID = "transitionId";
    static final String TRANSITION_NAME = "transitionName";
    static final String COMMENT = "comment";
    static final String USER = "user";
    static final String ISSUE = "issue";
    static final String TIMESTAMP = "timestamp";
    static final String ENTRY = "entry";
    static final String ACTION_ID = "actionId";
    private final IssueBeanFactory issueBeanFactory;
    private final UserBeanFactory userBeanFactory;

    public TransitionMapper(IssueBeanFactory issueBeanFactory, UserBeanFactory userBeanFactory) {
        this.issueBeanFactory = issueBeanFactory;
        this.userBeanFactory = userBeanFactory;
    }

    public Map<String, Object> toMap(Map transientVars, ApplicationUser user, MutableIssue issue) {
        WorkflowEntry entry = (WorkflowEntry)transientVars.get(ENTRY);
        ImmutableMap.Builder transition = ImmutableMap.builder();
        Integer actionId = (Integer)transientVars.get(ACTION_ID);
        WorkflowDescriptor workflowDescriptor = (WorkflowDescriptor)transientVars.get(WORKFLOW_DESCRIPTOR);
        ActionDescriptor actionDescriptor = workflowDescriptor.getAction(actionId.intValue());
        Step createdStep = (Step)transientVars.get(CREATED_STEP);
        WorkflowStore workflowStore = (WorkflowStore)transientVars.get(WORKFLOW_STORE);
        transition.put((Object)WORKFLOW_ID, (Object)entry.getId()).put((Object)WORKFLOW_NAME, (Object)entry.getWorkflowName()).put((Object)TRANSITION_ID, (Object)actionId).put((Object)TRANSITION_NAME, (Object)actionDescriptor.getName()).put((Object)FROM_STATUS, (Object)this.findPreviousStatus(createdStep, entry, workflowStore, workflowDescriptor)).put((Object)TO_STATUS, (Object)this.getToStatus(workflowDescriptor, createdStep));
        ImmutableMap.Builder transitionContext = ImmutableMap.builder();
        transitionContext.put((Object)TRANSITION_CONTEXT, (Object)transition.build()).put((Object)COMMENT, transientVars.get(COMMENT) != null ? transientVars.get(COMMENT) : "").put((Object)USER, user != null ? this.userBeanFactory.createBean(user) : "");
        transitionContext.put((Object)ISSUE, (Object)this.issueBeanFactory.createBean((Issue)issue));
        transitionContext.put((Object)TIMESTAMP, (Object)createdStep.getStartDate().getTime());
        return transitionContext.build();
    }

    private String findPreviousStatus(Step currentStep, WorkflowEntry entry, WorkflowStore workflowStore, WorkflowDescriptor workflowDescriptor) {
        if (currentStep.getPreviousStepIds().length == 0) {
            return "";
        }
        long previousStepId = currentStep.getPreviousStepIds()[0];
        try {
            List historySteps = workflowStore.findHistorySteps(entry.getId());
            Step previousStep = historySteps.stream().filter(step -> step.getId() == previousStepId).findFirst().orElseGet(() -> null);
            if (previousStep == null) {
                LOG.error((Object)"Transition from cannot be found. It seems that workflow data is inconsistent.");
                return "";
            }
            return workflowDescriptor.getStep(previousStep.getStepId()).getName();
        }
        catch (StoreException e) {
            return "";
        }
    }

    private String getToStatus(WorkflowDescriptor workflowDescriptor, Step createdStep) {
        return (String)Option.option((Object)workflowDescriptor.getStep(createdStep.getStepId())).map(StepDescriptor::getName).getOrElse((Object)"");
    }
}

