/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.web;

import com.atlassian.jira.plugins.webhooks.web.OsgiServiceProvider;
import com.atlassian.jira.webhooks.UriVariablesProvider;
import com.atlassian.jira.webhooks.WebhookEventSection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.stereotype.Component;

@Component
public class DefaultOsgiServiceProvider
implements OsgiServiceProvider {
    private final ServiceTracker<UriVariablesProvider, UriVariablesProvider> uriVariablesProviderTracker;
    private final ServiceTracker<WebhookEventSection, WebhookEventSection> webhookEventSectionTracker;

    public DefaultOsgiServiceProvider(BundleContext bundleContext) {
        this.uriVariablesProviderTracker = new ServiceTracker(bundleContext, UriVariablesProvider.class.getName(), null);
        this.webhookEventSectionTracker = new ServiceTracker(bundleContext, WebhookEventSection.class.getName(), null);
        this.uriVariablesProviderTracker.open();
        this.webhookEventSectionTracker.open();
    }

    @PreDestroy
    public void onDestroy() {
        this.uriVariablesProviderTracker.close();
        this.webhookEventSectionTracker.close();
    }

    @Override
    public List<WebhookEventSection> getWebHookEventSections() {
        return Stream.of(this.webhookEventSectionTracker.getServices()).map(WebhookEventSection.class::cast).collect(Collectors.toList());
    }

    @Override
    public List<UriVariablesProvider> getUriVariablesProviders() {
        return Stream.of(this.uriVariablesProviderTracker.getServices()).map(UriVariablesProvider.class::cast).collect(Collectors.toList());
    }
}

