/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.url;

import com.atlassian.jira.event.comment.CommentEvent;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.plugins.webhooks.spi.JiraWebhookEvent;
import com.atlassian.jira.plugins.webhooks.url.context.CommentContextSerializer;
import com.atlassian.jira.plugins.webhooks.url.context.IssueContextSerializer;
import com.atlassian.jira.plugins.webhooks.url.context.ProjectContextSerializer;
import com.atlassian.jira.webhooks.UriVariablesProvider;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.webhooks.WebhookEvent;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class CommentEventVariablesProvider
implements UriVariablesProvider<CommentEvent> {
    private final ProjectContextSerializer projectContextSerializer;
    private final IssueContextSerializer issueContextSerializer;
    private final CommentContextSerializer commentContextSerializer;

    public CommentEventVariablesProvider(ProjectContextSerializer projectContextSerializer, IssueContextSerializer issueContextSerializer, CommentContextSerializer commentContextSerializer) {
        this.projectContextSerializer = projectContextSerializer;
        this.issueContextSerializer = issueContextSerializer;
        this.commentContextSerializer = commentContextSerializer;
    }

    public Map<String, Object> uriVariables(CommentEvent commentEvent) {
        Comment comment = commentEvent.getComment();
        return ImmutableMap.builder().putAll(this.projectContextSerializer.getContext(comment.getIssue().getProjectObject())).putAll(this.issueContextSerializer.getContext(comment.getIssue())).putAll(this.commentContextSerializer.getContext(comment)).build();
    }

    public List<WebhookEvent> supportedWebhookEvents() {
        return Lists.newArrayList((Object[])new WebhookEvent[]{JiraWebhookEvent.COMMENT_CREATED, JiraWebhookEvent.COMMENT_UPDATED, JiraWebhookEvent.COMMENT_DELETED});
    }

    public List<String> supportedUriVariables() {
        return Lists.newArrayList((Object[])new String[]{"project.key", "project.id", "issue.id", "issue.key", "comment.id"});
    }
}

