/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.spi;

import com.atlassian.crowd.event.user.AutoUserUpdatedEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserEditedEvent;
import com.atlassian.crowd.event.user.UserUpdatedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.event.AbstractProjectEvent;
import com.atlassian.jira.event.ProjectCreatedEvent;
import com.atlassian.jira.event.ProjectDeletedEvent;
import com.atlassian.jira.event.ProjectUpdatedEvent;
import com.atlassian.jira.event.comment.CommentCreatedEvent;
import com.atlassian.jira.event.comment.CommentDeletedEvent;
import com.atlassian.jira.event.comment.CommentEvent;
import com.atlassian.jira.event.comment.CommentUpdatedEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssuePreDeleteEvent;
import com.atlassian.jira.event.issue.IssueRelatedEvent;
import com.atlassian.jira.event.issue.link.IssueLinkCreatedEvent;
import com.atlassian.jira.event.issue.link.IssueLinkDeletedEvent;
import com.atlassian.jira.event.project.AbstractVersionEvent;
import com.atlassian.jira.event.project.ProjectArchivedEvent;
import com.atlassian.jira.event.project.ProjectRestoredEvent;
import com.atlassian.jira.event.project.VersionCreateEvent;
import com.atlassian.jira.event.project.VersionDeleteEvent;
import com.atlassian.jira.event.project.VersionMergeEvent;
import com.atlassian.jira.event.project.VersionMoveEvent;
import com.atlassian.jira.event.project.VersionReleaseEvent;
import com.atlassian.jira.event.project.VersionUnreleaseEvent;
import com.atlassian.jira.event.project.VersionUpdatedEvent;
import com.atlassian.jira.event.property.AbstractApplicationPropertySetEvent;
import com.atlassian.jira.event.property.BooleanApplicationPropertySetEvent;
import com.atlassian.jira.event.property.StringApplicationPropertySetEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.worklog.WorklogCreatedEvent;
import com.atlassian.jira.event.worklog.WorklogDeletedEvent;
import com.atlassian.jira.event.worklog.WorklogUpdatedEvent;
import com.atlassian.jira.plugins.webhooks.serializer.WebhookJsonEventFactory;
import com.atlassian.jira.plugins.webhooks.spi.JiraWebhookEvent;
import com.atlassian.jira.plugins.webhooks.url.UrlContextFactory;
import com.atlassian.jira.plugins.webhooks.workflow.WebHookPostFunctionEvent;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webhooks.Webhook;
import com.atlassian.webhooks.WebhookEvent;
import com.atlassian.webhooks.WebhookPublishRequest;
import com.atlassian.webhooks.WebhookScope;
import com.atlassian.webhooks.WebhookService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JiraWebhookEventPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(JiraWebhookEventPublisher.class);
    private static final int WEBHOOK_SYNC_CALL_TIMEOUT_MILLIS = JiraSystemProperties.getInstance().getInteger("jira.setup.webhook.sync.call.timeout.millis", Integer.valueOf(20000));
    private final EventPublisher eventPublisher;
    private final WebhookJsonEventFactory jsonEventFactory;
    private final UrlContextFactory urlContextFactory;
    private final WebhookService webhookService;
    private final JiraAuthenticationContext authenticationContext;
    private static final Set<Long> ISSUE_UPDATED_EVENT_IDS = Stream.of(EventType.ISSUE_ASSIGNED_ID, EventType.ISSUE_CLOSED_ID, EventType.ISSUE_REOPENED_ID, EventType.ISSUE_RESOLVED_ID, EventType.ISSUE_COMMENT_EDITED_ID, EventType.ISSUE_COMMENTED_ID, EventType.ISSUE_MOVED_ID, EventType.ISSUE_UPDATED_ID, EventType.ISSUE_WORKSTARTED_ID, EventType.ISSUE_WORKSTOPPED_ID, EventType.ISSUE_GENERICEVENT_ID, EventType.ISSUE_COMMENT_DELETED_ID).collect(Collectors.toSet());
    private static final Set<Long> ISSUE_WORKLOG_UPDATED_EVENT_IDS = Stream.of(EventType.ISSUE_WORKLOG_UPDATED_ID, EventType.ISSUE_WORKLOG_DELETED_ID, EventType.ISSUE_WORKLOGGED_ID).collect(Collectors.toSet());
    private static final Map<String, JiraWebhookEvent> APP_PROPERTY_CHANGE_EVETNTS = new HashMap<String, JiraWebhookEvent>();

    public JiraWebhookEventPublisher(@ComponentImport EventPublisher eventPublisher, WebhookJsonEventFactory jsonEventFactory, UrlContextFactory urlContextFactory, @ComponentImport WebhookService webhookService, JiraAuthenticationContext authenticationContext) {
        this.eventPublisher = eventPublisher;
        this.jsonEventFactory = jsonEventFactory;
        this.urlContextFactory = urlContextFactory;
        this.webhookService = webhookService;
        this.authenticationContext = authenticationContext;
    }

    @PreDestroy
    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @PostConstruct
    public void init() {
        this.eventPublisher.register((Object)this);
    }

    @EventListener(order=1000)
    public void onIssueEvent(IssueEvent event) {
        JiraWebhookEvent webhookEvent = this.mapToIssueEvent(event);
        if (webhookEvent == null) {
            LOG.debug("Unsupported IssueEvent webhook. {}", (Object)event.getEventTypeId());
            return;
        }
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, event, Optional.ofNullable(originalEventUser)), this.urlContextFactory.build((IssueRelatedEvent)event));
    }

    private JiraWebhookEvent mapToIssueEvent(IssueEvent event) {
        if (EventType.ISSUE_CREATED_ID.equals(event.getEventTypeId())) {
            return JiraWebhookEvent.ISSUE_CREATED;
        }
        if (ISSUE_UPDATED_EVENT_IDS.contains(event.getEventTypeId())) {
            return JiraWebhookEvent.ISSUE_UPDATED;
        }
        if (ISSUE_WORKLOG_UPDATED_EVENT_IDS.contains(event.getEventTypeId())) {
            return JiraWebhookEvent.WORKLOG_UPDATED_ISSUE_UPDATED;
        }
        return null;
    }

    @EventListener(order=1000)
    public void onIssuePreDeleteEvent(IssuePreDeleteEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.ISSUE_DELETED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishSyncWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, event, Optional.ofNullable(originalEventUser)), this.urlContextFactory.build((IssueRelatedEvent)event));
    }

    @EventListener
    public void onCommentCreatedEvent(CommentCreatedEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.COMMENT_CREATED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, event, Optional.ofNullable(originalEventUser)), this.urlContextFactory.build((CommentEvent)event));
    }

    @EventListener
    public void onCommentUpdatedEvent(CommentUpdatedEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.COMMENT_UPDATED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, event, Optional.ofNullable(originalEventUser)), this.urlContextFactory.build((CommentEvent)event));
    }

    @EventListener
    public void onCommentDeletedEvent(CommentDeletedEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.COMMENT_DELETED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishSyncWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, event, Optional.ofNullable(originalEventUser)), this.urlContextFactory.build((CommentEvent)event));
    }

    @EventListener
    public void onIssueLinkCreatedEvent(IssueLinkCreatedEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.ISSUE_LINK_CREATED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, event, Optional.ofNullable(originalEventUser)));
    }

    @EventListener
    public void onIssueLinkDeletedEvent(IssueLinkDeletedEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.ISSUE_LINK_DELETED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, event, Optional.ofNullable(originalEventUser)));
    }

    @EventListener
    public void onWorklogCreatedEvent(WorklogCreatedEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.WORKLOG_CREATED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, event, Optional.ofNullable(originalEventUser)));
    }

    @EventListener
    public void onWorklogUpdatedEvent(WorklogUpdatedEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.WORKLOG_UPDATED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, event, Optional.ofNullable(originalEventUser)));
    }

    @EventListener
    public void onWorklogDeletedEvent(WorklogDeletedEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.WORKLOG_DELETED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, event, Optional.ofNullable(originalEventUser)));
    }

    @EventListener
    public void onVersionReleaseEvent(VersionReleaseEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.VERSION_RELEASED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, (AbstractVersionEvent)event, Optional.ofNullable(originalEventUser)), this.urlContextFactory.build((AbstractVersionEvent)event));
    }

    @EventListener
    public void onVersionUnreleaseEvent(VersionUnreleaseEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.VERSION_UNRELEASED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, (AbstractVersionEvent)event, Optional.ofNullable(originalEventUser)), this.urlContextFactory.build((AbstractVersionEvent)event));
    }

    @EventListener
    public void onVersionCreateEvent(VersionCreateEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.VERSION_CREATED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, (AbstractVersionEvent)event, Optional.ofNullable(originalEventUser)), this.urlContextFactory.build((AbstractVersionEvent)event));
    }

    @EventListener
    public void onVersionMoveEvent(VersionMoveEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.VERSION_MOVED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, (AbstractVersionEvent)event, Optional.ofNullable(originalEventUser)), this.urlContextFactory.build((AbstractVersionEvent)event));
    }

    @EventListener
    public void onVersionUpdatedEvent(VersionUpdatedEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.VERSION_UPDATED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, (AbstractVersionEvent)event, Optional.ofNullable(originalEventUser)), this.urlContextFactory.build((AbstractVersionEvent)event));
    }

    @EventListener
    public void onVersionMergeEvent(VersionMergeEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.VERSION_MERGED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, event, Optional.ofNullable(originalEventUser)), this.urlContextFactory.build(event));
    }

    @EventListener
    public void onVersionDeleteEvent(VersionDeleteEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.VERSION_DELETED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, event, Optional.ofNullable(originalEventUser)), this.urlContextFactory.build((AbstractVersionEvent)event));
    }

    @EventListener
    public void onProjectCreatedEvent(ProjectCreatedEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.PROJECT_CREATED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, (AbstractProjectEvent)event, Optional.ofNullable(originalEventUser)), this.urlContextFactory.build((AbstractProjectEvent)event));
    }

    @EventListener
    public void onProjectUpdatedEvent(ProjectUpdatedEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.PROJECT_UPDATED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, (AbstractProjectEvent)event, Optional.ofNullable(originalEventUser)), this.urlContextFactory.build((AbstractProjectEvent)event));
    }

    @EventListener
    public void onProjectDeletedEvent(ProjectDeletedEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.PROJECT_DELETED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, (AbstractProjectEvent)event, Optional.ofNullable(originalEventUser)), this.urlContextFactory.build((AbstractProjectEvent)event));
    }

    @EventListener
    public void onProjectArchivedEvent(ProjectArchivedEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.PROJECT_ARCHIVED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, (AbstractProjectEvent)event, Optional.ofNullable(originalEventUser)), this.urlContextFactory.build((AbstractProjectEvent)event));
    }

    @EventListener
    public void onProjectRestoredEvent(ProjectRestoredEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.PROJECT_RESTORED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, (AbstractProjectEvent)event, Optional.ofNullable(originalEventUser)), this.urlContextFactory.build((AbstractProjectEvent)event));
    }

    @EventListener
    public void onUserCreatedEvent(UserCreatedEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.USER_CREATED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, event, Optional.ofNullable(originalEventUser)), this.urlContextFactory.build(event));
    }

    @EventListener
    public void onUserDeletedEvent(UserDeletedEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.USER_DELETED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, event, Optional.ofNullable(originalEventUser)), this.urlContextFactory.build(event));
    }

    @EventListener
    public void onUserEditedEvent(UserEditedEvent event) {
        this.onUserUpdatedEvent((UserUpdatedEvent)event);
    }

    @EventListener
    public void onAutoUserUpdatedEvent(AutoUserUpdatedEvent event) {
        this.onUserUpdatedEvent((UserUpdatedEvent)event);
    }

    private void onUserUpdatedEvent(UserUpdatedEvent event) {
        JiraWebhookEvent webhookEvent = JiraWebhookEvent.USER_UPDATED;
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, event, Optional.ofNullable(originalEventUser)), this.urlContextFactory.build(event));
    }

    @EventListener
    public void onBooleanApplicationPropertySetEvent(BooleanApplicationPropertySetEvent event) {
        JiraWebhookEvent webhookEvent = this.mapToOptionEvent((AbstractApplicationPropertySetEvent)event);
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        if (webhookEvent == null) {
            LOG.debug("Unsupported application property webhook. {}", (Object)event.getPropertyKey());
            return;
        }
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, event, Optional.ofNullable(originalEventUser)));
    }

    @EventListener
    public void onStringApplicationPropertySetEvent(StringApplicationPropertySetEvent event) {
        JiraWebhookEvent webhookEvent = this.mapToOptionEvent((AbstractApplicationPropertySetEvent)event);
        ApplicationUser originalEventUser = this.authenticationContext.getLoggedInUser();
        if (webhookEvent == null) {
            LOG.debug("Unsupported application property webhook. {}", (Object)event.getPropertyKey());
            return;
        }
        this.publishWebhook(webhookEvent, () -> this.jsonEventFactory.build((WebhookEvent)webhookEvent, event, Optional.ofNullable(originalEventUser)));
    }

    private JiraWebhookEvent mapToOptionEvent(AbstractApplicationPropertySetEvent event) {
        return APP_PROPERTY_CHANGE_EVETNTS.get(event.getPropertyKey());
    }

    @EventListener
    public void onWebHookPostFunctionEvent(WebHookPostFunctionEvent event) {
        Optional webHook = this.webhookService.findById(event.getWebHookConsumerId());
        webHook.ifPresent(w -> this.webhookService.publish(WebhookPublishRequest.builder((Webhook)w, (WebhookEvent)JiraWebhookEvent.JIRA_WEBHOOK_POST_FUNCTION, event.getPayload(), this.urlContextFactory.build(event)).eventScope(WebhookScope.GLOBAL).build()));
    }

    private void publishSyncWebhook(WebhookEvent webhookEvent, Supplier<Map<String, Object>> payloadSupplier, Map<String, Object> context) {
        if (webhookEvent == null) {
            return;
        }
        Semaphore semaphore = new Semaphore(0);
        this.publishWebhook(webhookEvent, payloadSupplier, context, Optional.of(() -> {
            LOG.trace("All dispatchers finished");
            semaphore.release();
        }));
        try {
            LOG.trace("Waiting for webhook dispatcher");
            semaphore.tryAcquire(WEBHOOK_SYNC_CALL_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Webhook callback not invoked within " + WEBHOOK_SYNC_CALL_TIMEOUT_MILLIS + "ms");
        }
    }

    private void publishWebhook(WebhookEvent webhookEvent, Supplier<Map<String, Object>> payloadSupplier, Map<String, Object> context) {
        if (webhookEvent == null) {
            return;
        }
        this.publishWebhook(webhookEvent, payloadSupplier, context, Optional.empty());
    }

    private void publishWebhook(WebhookEvent webhookEvent, Supplier<Map<String, Object>> payloadSupplier, Map<String, Object> context, Optional<Runnable> callback) {
        LOG.trace("Publishing webhook {}", (Object)webhookEvent.getId());
        WebhookPublishRequest.SearchBuilder webhookRequestBuilder = WebhookPublishRequest.builder((WebhookEvent)webhookEvent, payloadSupplier, context).scopes(WebhookScope.GLOBAL, new WebhookScope[0]).eventScope(WebhookScope.GLOBAL);
        callback.ifPresent(arg_0 -> ((WebhookPublishRequest.SearchBuilder)webhookRequestBuilder).invocationCompletedCallback(arg_0));
        this.webhookService.publish(webhookRequestBuilder.build());
    }

    private void publishWebhook(WebhookEvent webhookEvent, Supplier<Map<String, Object>> payloadSupplier) {
        this.publishWebhook(webhookEvent, payloadSupplier, Collections.emptyMap(), Optional.empty());
    }

    static {
        APP_PROPERTY_CHANGE_EVETNTS.put("jira.option.voting", JiraWebhookEvent.OPTION_VOTING_CHANGED);
        APP_PROPERTY_CHANGE_EVETNTS.put("jira.option.watching", JiraWebhookEvent.OPTION_WATCHING_CHANGED);
        APP_PROPERTY_CHANGE_EVETNTS.put("jira.option.allowunassigned", JiraWebhookEvent.OPTION_UNASSIGNED_ISSUES_CHANGED);
        APP_PROPERTY_CHANGE_EVETNTS.put("jira.option.allowsubtasks", JiraWebhookEvent.OPTION_SUBTASKS_CHANGED);
        APP_PROPERTY_CHANGE_EVETNTS.put("jira.option.allowattachments", JiraWebhookEvent.OPTION_ATTACHMENTS_CHANGED);
        APP_PROPERTY_CHANGE_EVETNTS.put("jira.option.issuelinking", JiraWebhookEvent.OPTION_ISSUE_LINKS_CHANGED);
        APP_PROPERTY_CHANGE_EVETNTS.put("jira.option.timetracking", JiraWebhookEvent.OPTION_TIME_TRACKING_CHANGED);
    }
}

