/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.serializer.issuelink;

import com.atlassian.jira.event.issue.link.IssueLinkCreatedEvent;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.plugins.webhooks.serializer.AbstractJiraEventSerializer;
import com.atlassian.jira.plugins.webhooks.serializer.issuelink.IssueLinkBean;
import com.atlassian.jira.plugins.webhooks.serializer.issuelink.IssueLinkTypeBean;
import com.google.common.collect.ImmutableMap;
import org.springframework.stereotype.Component;

@Component
public class IssueLinkCreatedEventSerializer
extends AbstractJiraEventSerializer<IssueLinkCreatedEvent> {
    @Override
    protected Long getTimestamp(IssueLinkCreatedEvent event) {
        return event.getEventCreation().toEpochMilli();
    }

    @Override
    protected ImmutableMap.Builder<String, Object> putFields(IssueLinkCreatedEvent event, ImmutableMap.Builder<String, Object> defaultJson) {
        IssueLink link = event.getIssueLink();
        return defaultJson.put((Object)"issueLink", (Object)new IssueLinkBean(link.getId(), link.getSourceId(), link.getDestinationId(), new IssueLinkTypeBean(link.getIssueLinkType()), link.getSequence(), link.isSystemLink()));
    }
}

