/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.jql;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.index.ThreadLocalSearcherCache;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.plugins.webhooks.jql.JqlValidator;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class JqlIssueMatcher {
    private static final Logger SLOW_LOG = Logger.getLogger((String)(JqlIssueMatcher.class.getName() + "_SLOW"));
    private static final Logger LOG = Logger.getLogger(JqlIssueMatcher.class);
    private final SearchService searchService;
    private final JqlQueryParser jqlQueryParser;
    private final JqlValidator jqlValidator;
    private final JiraThreadLocalUtil jiraThreadLocalUtil;

    public JqlIssueMatcher(@ComponentImport SearchService searchService, @ComponentImport JqlQueryParser jqlQueryParser, JqlValidator jqlValidator, @ComponentImport JiraThreadLocalUtil jiraThreadLocalUtil) {
        this.searchService = searchService;
        this.jqlQueryParser = jqlQueryParser;
        this.jqlValidator = jqlValidator;
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean match(String jql, String issueKey) {
        if (StringUtils.isBlank((CharSequence)jql)) {
            return true;
        }
        if (!this.jqlValidator.isJqlValid(jql)) {
            LOG.error((Object)String.format("The following JQL query '%-1.800s' defined for filtering webhook events is incorrect. Filtering has been disabled for webhook.", jql));
            return true;
        }
        try {
            Query query = this.getQuery(issueKey, jql);
            long startTime = System.currentTimeMillis();
            this.jiraThreadLocalUtil.preCall();
            ThreadLocalSearcherCache.startSearcherContext();
            boolean matches = this.searchService.searchCountOverrideSecurity(null, query) > 0L;
            long queryTime = System.currentTimeMillis() - startTime;
            if (queryTime > 50L) {
                String logMessage = String.format("JQL query '%-1.800s' produced lucene query and took '%d' ms to run.", query.toString(), queryTime);
                SLOW_LOG.info((Object)logMessage);
            }
            boolean bl = matches;
            return bl;
        }
        catch (SearchException e) {
            boolean bl = false;
            return bl;
        }
        catch (JqlParseException e) {
            LOG.error((Object)"Query could not be parsed", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            ThreadLocalSearcherCache.stopAndCloseSearcherContext();
            this.jiraThreadLocalUtil.postCall();
        }
    }

    private Query getQuery(String issueKey, String jql) throws JqlParseException {
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder((Query)this.jqlQueryParser.parseQuery(jql));
        return queryBuilder.where().and().issue(new String[]{issueKey}).buildQuery();
    }
}

