/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.ao.upgrade;

import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkflowWebhookIdUpdater {
    private static final Logger log = LoggerFactory.getLogger(WorkflowWebhookIdUpdater.class);
    private final WorkflowManager workflowManager;

    public WorkflowWebhookIdUpdater(@ComponentImport WorkflowManager workflowManager) {
        this.workflowManager = workflowManager;
    }

    public void update(Map<Integer, Integer> renewedWebhookIds) {
        if (renewedWebhookIds == null || renewedWebhookIds.isEmpty()) {
            return;
        }
        for (JiraWorkflow workflow : this.workflowManager.getWorkflowsIncludingDrafts()) {
            Collection actions = workflow.getAllActions();
            for (ActionDescriptor actionDescriptor : actions) {
                List postFunctions = actionDescriptor.getUnconditionalResult().getPostFunctions();
                for (FunctionDescriptor descriptor : postFunctions) {
                    Integer webhookId = this.getWebhookId(descriptor);
                    if (webhookId == null) continue;
                    if (renewedWebhookIds.get(webhookId) == null) {
                        log.warn("Potential data issue. Old webhook ID was not found in migration mappings.");
                        continue;
                    }
                    Integer newWebhookId = renewedWebhookIds.get(webhookId);
                    descriptor.getArgs().put("field.webhookId", newWebhookId);
                    this.workflowManager.saveWorkflowWithoutAudit(workflow);
                    log.debug("Workflow transition. Webhook ID change after migration {} -> {}", (Object)webhookId, (Object)newWebhookId);
                }
            }
        }
    }

    private Integer getWebhookId(FunctionDescriptor descriptor) {
        Object potentialWebhookId = descriptor.getArgs().get("field.webhookId");
        if (potentialWebhookId == null) {
            return null;
        }
        try {
            return Integer.parseInt(potentialWebhookId.toString());
        }
        catch (NumberFormatException nfe) {
            log.error("Data issue found. Webhook ID should be Integer. Found: {}", potentialWebhookId);
            return null;
        }
    }
}

