/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.ao.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.jira.plugins.webhooks.ao.WebhookDao;
import com.atlassian.jira.plugins.webhooks.ao.upgrade.WorkflowWebhookIdUpdater;
import com.atlassian.webhooks.migration.WebhookDTO;
import com.atlassian.webhooks.migration.WebhooksDataUpgrade;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateToWebhooks7Task
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(MigrateToWebhooks7Task.class);
    private final BundleContext bundleContext;
    private final WorkflowWebhookIdUpdater workflowWebhookIdUpdater;

    public MigrateToWebhooks7Task(BundleContext bundleContext, WorkflowWebhookIdUpdater workflowWebhookIdUpdater) {
        this.bundleContext = bundleContext;
        this.workflowWebhookIdUpdater = workflowWebhookIdUpdater;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"2");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        try {
            log.info("Migrating webhooks to version external atlassian-webhooks-plugin.");
            ao.migrate(new Class[]{WebhookDao.class});
            List webhookDTOs = Stream.of((WebhookDao[])ao.find(WebhookDao.class)).map(this::convert).collect(Collectors.toList());
            WebhooksDataUpgrade dataUpgrade = this.dataUpgrade();
            if (webhookDTOs.isEmpty()) {
                log.info("Webhooks migration completed. No old data found.");
                dataUpgrade.registerExternalMigrationTask(Collections.emptyList(), ignoreResult -> {});
            } else {
                log.info("Webhooks migration; " + webhookDTOs.size() + " items to migrate");
                log.info("Delegating webhooks data migration to atlassian-webhooks ao.");
                dataUpgrade.registerExternalMigrationTask(webhookDTOs, result -> {
                    log.info("Migration data received from atlassian-webhooks by jira-webhooks.");
                    Executors.newSingleThreadExecutor().submit(() -> this.workflowWebhookIdUpdater.update((Map<Integer, Integer>)result));
                });
            }
        }
        catch (Exception e) {
            log.error("Webhooks migration failed", (Throwable)e);
        }
    }

    private WebhooksDataUpgrade dataUpgrade() {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(WebhooksDataUpgrade.class);
        if (serviceReference == null) {
            throw new RuntimeException("Can't find proper task for webhooks migration.");
        }
        WebhooksDataUpgrade dataUpgrade = (WebhooksDataUpgrade)this.bundleContext.getService(serviceReference);
        return dataUpgrade;
    }

    private WebhookDTO convert(WebhookDao webhookDao) {
        return WebhookDTO.builder().id(webhookDao.getID()).url(webhookDao.getUrl()).name(webhookDao.getName()).lastUpdated(webhookDao.getLastUpdated()).lastUpdatedUser(webhookDao.getLastUpdatedUser()).filters(webhookDao.getFilter()).registrationMethod(webhookDao.getRegistrationMethod()).enabled(webhookDao.isEnabled()).excludeBody(webhookDao.getExcludeIssueDetails()).parameters(webhookDao.getParameters()).events(webhookDao.getEncodedEvents()).createWebhookDTO();
    }
}

