/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue.issuelink;

import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.plugin.issuelink.IssueLinkRenderer;
import com.atlassian.jira.plugin.issuelink.IssueLinkRendererModuleDescriptor;
import com.atlassian.jira.plugin.viewissue.issuelink.IssueLinkContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class RemoteIssueLinkUtils {
    public static final String DEFAULT_RELATIONSHIP_I18N_KEY = "issuelinking.remote.link.relationship.default";

    private RemoteIssueLinkUtils() {
    }

    public static Map<String, List<IssueLinkContext>> convertToIssueLinkContexts(List<RemoteIssueLink> remoteIssueLinks, Long issueId, String baseUrl, I18nHelper i18n, PluginAccessor pluginAccessor) {
        HashMap contextsMap = Maps.newHashMap();
        for (RemoteIssueLink remoteIssueLink : remoteIssueLinks) {
            List<IssueLinkContext> contexts;
            IssueLinkRendererModuleDescriptor descriptor = RemoteIssueLinkUtils.getIssueLinkRendererModuleDescriptor(pluginAccessor, remoteIssueLink.getApplicationType());
            IssueLinkRenderer issueLinkRenderer = (IssueLinkRenderer)descriptor.getModule();
            if (!issueLinkRenderer.shouldDisplay(remoteIssueLink)) continue;
            String relationship = StringUtils.defaultIfEmpty((String)remoteIssueLink.getRelationship(), (String)i18n.getText(DEFAULT_RELATIONSHIP_I18N_KEY));
            if (contextsMap.containsKey(relationship)) {
                contexts = (List)contextsMap.get(relationship);
            } else {
                contexts = Lists.newArrayList();
                contextsMap.put(relationship, contexts);
            }
            String deleteUrl = String.format(baseUrl + "/secure/DeleteRemoteIssueLink.jspa?id=%d&remoteIssueLinkId=%d", issueId, remoteIssueLink.getId());
            String html = descriptor.getInitialHtml(remoteIssueLink);
            contexts.add(IssueLinkContext.newRemoteIssueLinkContext("remote-" + remoteIssueLink.getId(), deleteUrl, true, html, remoteIssueLink.getId(), issueLinkRenderer.requiresAsyncLoading(remoteIssueLink)));
        }
        return contextsMap;
    }

    public static String getFinalHtml(RemoteIssueLink remoteIssueLink, PluginAccessor pluginAccessor) {
        IssueLinkRendererModuleDescriptor descriptor = RemoteIssueLinkUtils.getIssueLinkRendererModuleDescriptor(pluginAccessor, remoteIssueLink.getApplicationType());
        return descriptor.getFinalHtml(remoteIssueLink);
    }

    private static IssueLinkRendererModuleDescriptor getIssueLinkRendererModuleDescriptor(PluginAccessor pluginAccessor, String applicationType) {
        if (StringUtils.isNotBlank((String)applicationType)) {
            List descriptors = pluginAccessor.getEnabledModuleDescriptorsByClass(IssueLinkRendererModuleDescriptor.class);
            for (IssueLinkRendererModuleDescriptor descriptor : descriptors) {
                if (!descriptor.handlesApplicationType(applicationType)) continue;
                return descriptor;
            }
        }
        return RemoteIssueLinkUtils.getDefaultLinkRendererModuleDescriptor(pluginAccessor);
    }

    private static IssueLinkRendererModuleDescriptor getDefaultLinkRendererModuleDescriptor(PluginAccessor pluginAccessor) {
        List descriptors = pluginAccessor.getEnabledModuleDescriptorsByClass(IssueLinkRendererModuleDescriptor.class);
        for (IssueLinkRendererModuleDescriptor descriptor : descriptors) {
            if (!descriptor.isDefaultHandler()) continue;
            return descriptor;
        }
        throw new IllegalStateException("No default issue link renderer module descriptor found");
    }
}

