/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue.issuelink;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.LinkCollection;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugin.viewissue.issuelink.IssueLinkContext;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class LocalIssueLinkUtils {
    private LocalIssueLinkUtils() {
    }

    public static Map<String, List<IssueLinkContext>> convertToIssueLinkContexts(LinkCollection linkCollection, Long issueId, String baseUrl, FieldVisibilityManager fieldVisibilityManager) {
        HashMap relationshipLinkMap = Maps.newHashMap();
        for (IssueLinkType issueLinkType : linkCollection.getLinkTypes()) {
            String relationship;
            List outwardIssues = linkCollection.getOutwardIssues(issueLinkType.getName());
            List inwardIssues = linkCollection.getInwardIssues(issueLinkType.getName());
            String linkTypeId = issueLinkType.getId().toString();
            if (CollectionUtils.isNotEmpty((Collection)outwardIssues)) {
                relationship = issueLinkType.getOutward();
                LocalIssueLinkUtils.getOrCreateList(relationshipLinkMap, relationship).addAll(LocalIssueLinkUtils.convertLocalIssuesToContexts(issueId, outwardIssues, InternalIssueDirection.OUTWARD, linkTypeId, baseUrl, fieldVisibilityManager));
            }
            if (!CollectionUtils.isNotEmpty((Collection)inwardIssues)) continue;
            relationship = issueLinkType.getInward();
            LocalIssueLinkUtils.getOrCreateList(relationshipLinkMap, relationship).addAll(LocalIssueLinkUtils.convertLocalIssuesToContexts(issueId, inwardIssues, InternalIssueDirection.INWARD, linkTypeId, baseUrl, fieldVisibilityManager));
        }
        return relationshipLinkMap;
    }

    private static List<IssueLinkContext> convertLocalIssuesToContexts(Long issueId, List<Issue> linkedIssues, InternalIssueDirection direction, String linkTypeId, String baseUrl, FieldVisibilityManager fieldVisibilityManager) {
        ArrayList issueLinkContexts = Lists.newArrayList();
        for (Issue linkedIssue : linkedIssues) {
            issueLinkContexts.add(LocalIssueLinkUtils.convertLocalIssueToContext(issueId, linkedIssue, direction, linkTypeId, baseUrl, fieldVisibilityManager));
        }
        return issueLinkContexts;
    }

    private static IssueLinkContext convertLocalIssueToContext(Long issueId, Issue linkedIssue, InternalIssueDirection direction, String linkTypeId, String baseUrl, FieldVisibilityManager fieldVisibilityManager) {
        String deleteTypeName = direction == InternalIssueDirection.OUTWARD ? "destId" : "sourceId";
        String deleteUrl = String.format(baseUrl + "/secure/DeleteLink.jspa?id=%d&%s=%s&linkType=%s", issueId, deleteTypeName, linkedIssue.getId(), linkTypeId);
        String htmlElementId = "internal-" + linkedIssue.getId() + "_" + linkTypeId;
        Map<String, Object> localIssueLinkContext = LocalIssueLinkUtils.getLocalIssueLinkVelocityContext(linkedIssue, baseUrl, fieldVisibilityManager);
        return IssueLinkContext.newLocalIssueLinkContext(htmlElementId, deleteUrl, false, localIssueLinkContext);
    }

    private static Map<String, Object> getLocalIssueLinkVelocityContext(Issue linkedIssue, String baseUrl, FieldVisibilityManager fieldVisibilityManager) {
        String priorityIconUrl = null;
        String priorityIconTooltip = null;
        Priority priority = linkedIssue.getPriorityObject();
        if (priority != null && !fieldVisibilityManager.isFieldHidden("priority", linkedIssue)) {
            priorityIconUrl = LocalIssueLinkUtils.asAbsoluteUrl(baseUrl, priority.getIconUrl());
            priorityIconTooltip = priority.getName() + " - " + priority.getDescription();
        }
        ImmutableMap.Builder contextBuilder = ImmutableMap.builder();
        LocalIssueLinkUtils.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "url", baseUrl + "/browse/" + linkedIssue.getKey());
        LocalIssueLinkUtils.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "title", linkedIssue.getKey());
        LocalIssueLinkUtils.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "issueKey", linkedIssue.getKey());
        LocalIssueLinkUtils.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "iconUrl", LocalIssueLinkUtils.asAbsoluteUrl(baseUrl, linkedIssue.getIssueTypeObject().getIconUrl()));
        LocalIssueLinkUtils.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "iconTooltip", linkedIssue.getIssueTypeObject().getName() + " - " + linkedIssue.getIssueTypeObject().getDescription());
        LocalIssueLinkUtils.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "summary", linkedIssue.getSummary());
        LocalIssueLinkUtils.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "tooltip", linkedIssue.getKey() + ": " + linkedIssue.getSummary());
        LocalIssueLinkUtils.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "priorityIconUrl", priorityIconUrl);
        LocalIssueLinkUtils.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "priorityIconTooltip", priorityIconTooltip);
        Status status = linkedIssue.getStatusObject();
        if (status != null) {
            LocalIssueLinkUtils.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "statusIconUrl", LocalIssueLinkUtils.asAbsoluteUrl(baseUrl, status.getIconUrl()));
            LocalIssueLinkUtils.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "statusIconTooltip", status.getName() + " - " + status.getDescription());
            LocalIssueLinkUtils.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "status", status.getSimpleStatus());
        }
        LocalIssueLinkUtils.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "resolved", linkedIssue.getResolutionObject() != null);
        return contextBuilder.build();
    }

    private static void putMap(ImmutableMap.Builder<String, Object> mapBuilder, String key, Object value) {
        if (value != null) {
            mapBuilder.put((Object)key, value);
        }
    }

    private static <K, V> List<V> getOrCreateList(Map<K, List<V>> map, K key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        ArrayList list = Lists.newArrayList();
        map.put(key, list);
        return list;
    }

    private static String asAbsoluteUrl(String baseUrl, String url) {
        try {
            return new URL(url).toString();
        }
        catch (MalformedURLException e) {
            return baseUrl + url;
        }
    }

    private static enum InternalIssueDirection {
        OUTWARD,
        INWARD;

    }
}

