/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculator;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculatorFactory;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.bean.TimeTrackingGraphBean;
import com.atlassian.jira.web.bean.TimeTrackingGraphBeanFactory;
import com.atlassian.plugin.PluginParseException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import webwork.action.ActionContext;

public class TimeTrackingViewIssueContextProvider
implements CacheableContextProvider {
    private static final String ISSUE = "issue";
    private static final String AGGREGATE_TIME_TRACKING_GRAPH_BEAN = "aggregateTimeTrackingGraphBean";
    private static final String HAS_DATA = "hasData";
    private static final String TIME_TRACKING_GRAPH_BEAN = "timeTrackingGraphBean";
    private static final String I18N = "i18n";
    private final JiraAuthenticationContext authenticationContext;
    private final AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory;
    private final TimeTrackingGraphBeanFactory timeTrackingGraphBeanFactory;

    public TimeTrackingViewIssueContextProvider(JiraAuthenticationContext authenticationContext, AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory, TimeTrackingGraphBeanFactory timeTrackingGraphBeanFactory) {
        this.authenticationContext = authenticationContext;
        this.aggregateTimeTrackingCalculatorFactory = aggregateTimeTrackingCalculatorFactory;
        this.timeTrackingGraphBeanFactory = timeTrackingGraphBeanFactory;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        MapBuilder paramsBuilder = MapBuilder.newBuilder(context);
        Issue issue = (Issue)context.get(ISSUE);
        TimeTrackingGraphBean timeTrackingGraphBean = this.timeTrackingGraphBeanFactory.createBean(issue, TimeTrackingGraphBeanFactory.Style.SHORT, this.authenticationContext.getI18nHelper());
        AggregateTimeTrackingBean aggregates = this.getAggregates(issue, context);
        if (aggregates.getSubTaskCount() > 0) {
            TimeTrackingGraphBean aggregateTimeTrackingGraphBean = this.timeTrackingGraphBeanFactory.createBean(aggregates, TimeTrackingGraphBeanFactory.Style.SHORT, this.authenticationContext.getI18nHelper());
            paramsBuilder.add((Object)AGGREGATE_TIME_TRACKING_GRAPH_BEAN, (Object)aggregateTimeTrackingGraphBean);
            paramsBuilder.add((Object)HAS_DATA, (Object)(timeTrackingGraphBean.hasData() || aggregateTimeTrackingGraphBean.hasData() ? 1 : 0));
        } else {
            paramsBuilder.add((Object)HAS_DATA, (Object)timeTrackingGraphBean.hasData());
        }
        paramsBuilder.add((Object)TIME_TRACKING_GRAPH_BEAN, (Object)timeTrackingGraphBean);
        paramsBuilder.add((Object)I18N, (Object)this.authenticationContext.getI18nHelper());
        Map startingParams = paramsBuilder.toMap();
        Map params = JiraVelocityUtils.getDefaultVelocityParams((Map)startingParams, (JiraAuthenticationContext)this.authenticationContext);
        return params;
    }

    private AggregateTimeTrackingBean getAggregates(Issue issue, Map<String, Object> context) {
        HttpServletRequest request = this.getRequest(context);
        if (request != null) {
            AggregateTimeTrackingBean aggregates = (AggregateTimeTrackingBean)request.getAttribute("atl.jira.timetracking.aggregate.bean." + issue.getId());
            if (aggregates == null) {
                AggregateTimeTrackingCalculator calculator = this.aggregateTimeTrackingCalculatorFactory.getCalculator(issue);
                aggregates = calculator.getAggregates(issue);
                request.setAttribute("atl.jira.timetracking.aggregate.bean." + issue.getId(), (Object)aggregates);
            }
            return aggregates;
        }
        AggregateTimeTrackingCalculator calculator = this.aggregateTimeTrackingCalculatorFactory.getCalculator(issue);
        return calculator.getAggregates(issue);
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        Issue issue = (Issue)context.get(ISSUE);
        User user = (User)context.get("user");
        return issue.getId() + "/" + (user == null ? "" : user.getName());
    }

    protected HttpServletRequest getRequest(Map<String, Object> context) {
        HttpServletRequest request = null;
        JiraHelper jiraHelper = (JiraHelper)context.get("helper");
        if (jiraHelper != null && (request = jiraHelper.getRequest()) != null) {
            return request;
        }
        Object o = context.get("request");
        if (o != null && o instanceof HttpServletRequest) {
            request = (HttpServletRequest)o;
            return request;
        }
        request = ExecutingHttpRequest.get();
        if (request != null) {
            return request;
        }
        return ActionContext.getRequest();
    }
}

