/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bean.SubTask;
import com.atlassian.jira.bean.SubTaskBean;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueUtils;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculator;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculatorFactory;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.component.IssueTableLayoutBean;
import com.atlassian.jira.web.component.IssueTableWebComponent;
import com.atlassian.jira.web.component.TableLayoutFactory;
import com.atlassian.plugin.PluginParseException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class SubTasksContxtProvider
implements CacheableContextProvider {
    private final SubTaskManager subTaskManager;
    private final JiraAuthenticationContext authenticationContext;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory;
    private final TableLayoutFactory tableLayoutFactory;

    public SubTasksContxtProvider(SubTaskManager subTaskManager, JiraAuthenticationContext authenticationContext, VelocityRequestContextFactory velocityRequestContextFactory, AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory) {
        this.subTaskManager = subTaskManager;
        this.authenticationContext = authenticationContext;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.aggregateTimeTrackingCalculatorFactory = aggregateTimeTrackingCalculatorFactory;
        this.tableLayoutFactory = (TableLayoutFactory)ComponentAccessor.getComponent(TableLayoutFactory.class);
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        User user = this.authenticationContext.getLoggedInUser();
        return issue.getId() + "/" + (user == null ? "" : user.getName());
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        MapBuilder paramsBuilder = MapBuilder.newBuilder(context);
        Issue issue = (Issue)context.get("issue");
        User user = this.authenticationContext.getLoggedInUser();
        SubTaskBean subTaskBean = this.getSubTaskBean(issue);
        VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        String selectedIssueId = requestContext.getRequestParameter("selectedIssueId");
        paramsBuilder.add((Object)"hasSubTasks", (Object)(!subTaskBean.getSubTasks(this.getSubTaskView()).isEmpty() ? 1 : 0));
        paramsBuilder.add((Object)"selectedIssueId", (Object)selectedIssueId);
        paramsBuilder.add((Object)"subTaskTable", (Object)new SubTaskTableRenderer(issue, user));
        return paramsBuilder.toMap();
    }

    private AggregateTimeTrackingBean getAggregates(Issue issue) {
        HttpServletRequest request = this.getRequest();
        if (request != null) {
            AggregateTimeTrackingBean aggregates = (AggregateTimeTrackingBean)request.getAttribute("atl.jira.timetracking.aggregate.bean." + issue.getId());
            if (aggregates == null) {
                AggregateTimeTrackingCalculator calculator = this.aggregateTimeTrackingCalculatorFactory.getCalculator(issue);
                aggregates = calculator.getAggregates(issue);
                request.setAttribute("atl.jira.timetracking.aggregate.bean." + issue.getId(), (Object)aggregates);
            }
            return aggregates;
        }
        AggregateTimeTrackingCalculator calculator = this.aggregateTimeTrackingCalculatorFactory.getCalculator(issue);
        return calculator.getAggregates(issue);
    }

    private SubTaskBean getSubTaskBean(Issue issue) {
        HttpServletRequest request = this.getRequest();
        if (request != null) {
            SubTaskBean subtaskBean = (SubTaskBean)request.getAttribute("atl.jira.subtask.bean." + issue.getKey());
            if (subtaskBean != null) {
                return subtaskBean;
            }
            subtaskBean = this.subTaskManager.getSubTaskBean(issue, this.authenticationContext.getLoggedInUser());
            request.setAttribute("atl.jira.subtask.bean." + issue.getKey(), (Object)subtaskBean);
            return subtaskBean;
        }
        return this.subTaskManager.getSubTaskBean(issue, this.authenticationContext.getLoggedInUser());
    }

    private String getSubTaskView() {
        return this.getSessionBackedRequestParam("subTaskView", "all", "jira.user.subtaskview");
    }

    private String getSessionBackedRequestParam(String requestParamName, String defaultValue, String sessionKey) {
        VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        VelocityRequestSession session = requestContext.getSession();
        String requestParameter = requestContext.getRequestParameter(requestParamName);
        if (StringUtils.isNotBlank((String)requestParameter)) {
            if (requestParameter.equals(defaultValue)) {
                session.removeAttribute(sessionKey);
                return defaultValue;
            }
            session.setAttribute(sessionKey, (Object)requestParameter);
            return requestParameter;
        }
        String sortOrder = (String)session.getAttribute(sessionKey);
        return StringUtils.isNotBlank((String)sortOrder) ? sortOrder : defaultValue;
    }

    private String getTableHtml(Issue issue, User user) {
        IssueTableLayoutBean layout;
        AggregateTimeTrackingBean aggregateTTBean = this.getAggregates(issue);
        SubTaskBean subTaskBean = this.getSubTaskBean(issue);
        String subTaskView = this.getSubTaskView();
        Collection issues = subTaskBean.getSubTasks(subTaskView);
        ArrayList issueObjects = Lists.newArrayList();
        boolean atLeastOneIssueHasTimeTrackingData = false;
        for (SubTask subTask : issues) {
            Issue subTaskIssue = subTask.getSubTask();
            atLeastOneIssueHasTimeTrackingData = atLeastOneIssueHasTimeTrackingData || IssueUtils.hasTimeTracking((Issue)subTaskIssue);
            issueObjects.add(subTaskIssue);
        }
        IssueTableWebComponent issueTable = new IssueTableWebComponent();
        try {
            layout = this.tableLayoutFactory.getSubTaskIssuesLayout(user, issue, subTaskBean, subTaskView, atLeastOneIssueHasTimeTrackingData);
        }
        catch (ColumnLayoutStorageException e) {
            throw new RuntimeException(e);
        }
        catch (FieldException e) {
            throw new RuntimeException(e);
        }
        layout.addCellDisplayParam("aggTTBean", (Object)aggregateTTBean);
        layout.addCellDisplayParam("issueStatusMaxWidth", (Object)"short");
        return issueTable.getHtml(layout, (List)issueObjects, null);
    }

    protected HttpServletRequest getRequest() {
        return ExecutingHttpRequest.get();
    }

    public class SubTaskTableRenderer {
        private final Issue issue;
        private final User user;

        public SubTaskTableRenderer(Issue issue, User user) {
            this.user = user;
            this.issue = issue;
        }

        public String getHtml() {
            return SubTasksContxtProvider.this.getTableHtml(this.issue, this.user);
        }
    }
}

