/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.webfragment.SimpleLinkFactory;
import com.atlassian.jira.plugin.webfragment.descriptors.SimpleLinkFactoryModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SubTaskViewOptionsFactory
implements SimpleLinkFactory {
    private final VelocityRequestContextFactory requestContextFactory;
    private final JiraAuthenticationContext authenticationContext;

    public SubTaskViewOptionsFactory(VelocityRequestContextFactory requestContextFactory, JiraAuthenticationContext authenticationContext) {
        this.requestContextFactory = requestContextFactory;
        this.authenticationContext = authenticationContext;
    }

    public void init(SimpleLinkFactoryModuleDescriptor descriptor) {
    }

    public List<SimpleLink> getLinks(User user, Map<String, Object> params) {
        VelocityRequestContext requestContext = this.requestContextFactory.getJiraVelocityRequestContext();
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        Issue issue = (Issue)params.get("issue");
        VelocityRequestSession session = requestContext.getSession();
        String baseUrl = requestContext.getBaseUrl();
        String subTaskView = (String)session.getAttribute("jira.user.subtaskview");
        boolean showingAll = "all".equals("all");
        if (StringUtils.isNotBlank((String)subTaskView)) {
            showingAll = subTaskView.equals("all");
        }
        SimpleLinkImpl allLink = new SimpleLinkImpl("subtasks-show-all", i18n.getText("viewissue.subtasks.tab.show.all.subtasks"), i18n.getText("viewissue.subtasks.tab.show.all.subtasks"), null, showingAll ? "aui-list-checked aui-checked" : "aui-list-checked", baseUrl + "/browse/" + issue.getKey() + "?subTaskView=all#issuetable", null);
        SimpleLinkImpl openLink = new SimpleLinkImpl("subtasks-show-open", i18n.getText("viewissue.subtasks.tab.show.open.subtasks"), i18n.getText("viewissue.subtasks.tab.show.open.subtasks"), null, !showingAll ? "aui-list-checked aui-checked" : "aui-list-checked", baseUrl + "/browse/" + issue.getKey() + "?subTaskView=unresolved#issuetable", null);
        return CollectionBuilder.list((Object[])new SimpleLink[]{allLink, openLink});
    }
}

