/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DescriptionBlockContextProvider
implements ContextProvider {
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final IssueManager issueManager;

    public DescriptionBlockContextProvider(FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, FieldScreenRendererFactory fieldScreenRendererFactory, IssueManager issueManager) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.issueManager = issueManager;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        MapBuilder paramsBuilder = MapBuilder.newBuilder(context);
        Issue issue = (Issue)context.get("issue");
        User user = (User)context.get("user");
        boolean isEditable = false;
        if (this.issueManager.isEditable(issue, user)) {
            FieldScreenRenderer fieldScreenRenderer = this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)IssueOperations.EDIT_ISSUE_OPERATION);
            isEditable = fieldScreenRenderer.getFieldScreenRenderTabPosition("description") != null;
        }
        paramsBuilder.add((Object)"isEditable", (Object)isEditable);
        FieldLayoutItem fieldLayoutItem = this.fieldLayoutManager.getFieldLayout(issue).getFieldLayoutItem("description");
        if (fieldLayoutItem != null) {
            String renderedContent = this.rendererManager.getRenderedContent(fieldLayoutItem.getRendererType(), issue.getDescription(), issue.getIssueRenderContext());
            if (StringUtils.isNotBlank((String)renderedContent)) {
                paramsBuilder.add((Object)"descriptionHtml", (Object)renderedContent);
            }
        } else if (StringUtils.isNotBlank((String)issue.getDescription())) {
            paramsBuilder.add((Object)"descriptionHtml", (Object)issue.getDescription());
        }
        return paramsBuilder.toMap();
    }
}

