/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue;

import com.atlassian.core.util.FileSize;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.attachment.FileNameBasedVersionedAttachmentsList;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentCreationDateComparator;
import com.atlassian.jira.issue.attachment.AttachmentFileNameCreationDateComparator;
import com.atlassian.jira.issue.attachment.AttachmentItem;
import com.atlassian.jira.issue.attachment.AttachmentItems;
import com.atlassian.jira.issue.attachment.AttachmentZipKit;
import com.atlassian.jira.issue.attachment.AttachmentsCategoriser;
import com.atlassian.jira.issue.attachment.MimetypesFileTypeMap;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.issue.thumbnail.ThumbnailedImage;
import com.atlassian.jira.plugin.viewissue.AttachmentBlockContextHelper;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.web.bean.NonZipExpandableExtensions;
import com.atlassian.jira.web.util.FileIconBean;
import com.atlassian.jira.web.util.FileIconUtil;
import com.atlassian.plugin.PluginParseException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;

public class AttachmentBlockContextProvider
implements CacheableContextProvider {
    private static final Set WELL_KNOWN_MIMETYPES = new LinkedHashSet();
    private final AttachmentManager attachmentManager;
    private final JiraAuthenticationContext authenticationContext;
    private final ThumbnailManager thumbnailManager;
    private final UserManager userManager;
    private final NonZipExpandableExtensions nonZipExpandableExtensions;
    private final FileIconUtil fileIconUtil;
    private final DateTimeFormatter dateTimeFormatter;
    private final AttachmentZipKit attachmentZipKit;
    private final AttachmentBlockContextHelper helper;

    public AttachmentBlockContextProvider(AttachmentManager attachmentManager, JiraAuthenticationContext authenticationContext, ThumbnailManager thumbnailManager, UserManager userManager, FileIconUtil fileIconUtil, DateTimeFormatter dateTimeFormatter, AttachmentBlockContextHelper helper) {
        this.attachmentManager = attachmentManager;
        this.authenticationContext = authenticationContext;
        this.thumbnailManager = thumbnailManager;
        this.userManager = userManager;
        this.nonZipExpandableExtensions = (NonZipExpandableExtensions)ComponentAccessor.getComponent(NonZipExpandableExtensions.class);
        this.fileIconUtil = fileIconUtil;
        this.dateTimeFormatter = dateTimeFormatter != null ? dateTimeFormatter.forLoggedInUser().withStyle(DateTimeStyle.COMPLETE) : null;
        this.attachmentZipKit = new AttachmentZipKit();
        this.helper = helper;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        MapBuilder paramsBuilder = MapBuilder.newBuilder(context);
        final Issue issue = (Issue)context.get("issue");
        ApplicationUser user = this.authenticationContext.getUser();
        boolean zipEnabled = this.helper.getZipSupport();
        AttachmentsCategoriser attachments = new AttachmentsCategoriser(this.thumbnailManager, new AttachmentsCategoriser.Source(){

            public List<Attachment> getAttachments() {
                return AttachmentBlockContextProvider.this.attachmentManager.getAttachments(issue, AttachmentBlockContextProvider.this.attachmentComparator());
            }
        });
        paramsBuilder.add((Object)"iconGenerator", (Object)new IconGenerator());
        paramsBuilder.add((Object)"fileSizeFormatter", (Object)new FileSize());
        paramsBuilder.add((Object)"hasAttachments", (Object)(!attachments.items().isEmpty() ? 1 : 0));
        paramsBuilder.add((Object)"openSquareBracket", (Object)JiraUrlCodec.encode((String)"["));
        paramsBuilder.add((Object)"closeSquareBracket", (Object)JiraUrlCodec.encode((String)"]"));
        paramsBuilder.add((Object)"imageAttachments", this.convertToSimpleAttachments(issue, attachments.itemsThatHaveThumbs(), zipEnabled, user));
        paramsBuilder.add((Object)"fileAttachments", this.convertToSimpleAttachments(issue, attachments.itemsThatDoNotHaveThumbs(), zipEnabled, user));
        paramsBuilder.add((Object)"maximumNumberOfZipEntriesToShow", (Object)this.helper.getMaximumNumberOfZipEntriesToShow());
        paramsBuilder.add((Object)"fullBaseUrl", (Object)JiraUrl.constructBaseUrl((HttpServletRequest)AttachmentBlockContextProvider.getRequest(context)));
        return paramsBuilder.toMap();
    }

    protected Comparator<Attachment> attachmentComparator() {
        String attachmentSortBy = this.helper.getAttachmentSortBy();
        String attachmentOrder = this.helper.getAttachmentOrder();
        Object attachmentComparator = "dateTime".equals(attachmentSortBy) ? new AttachmentCreationDateComparator() : new AttachmentFileNameCreationDateComparator(this.authenticationContext.getLocale());
        if ("desc".equals(attachmentOrder)) {
            attachmentComparator = Collections.reverseOrder(attachmentComparator);
        }
        return attachmentComparator;
    }

    private List<SimpleAttachment> convertToSimpleAttachments(Issue issue, AttachmentItems items, boolean zipEnabled, ApplicationUser user) {
        FileNameBasedVersionedAttachmentsList attachmentsList = new FileNameBasedVersionedAttachmentsList(items.attachments());
        CollectionBuilder builder = CollectionBuilder.newBuilder();
        for (AttachmentItem item : items) {
            boolean latestVersion = attachmentsList.isLatestVersion(item.attachment());
            boolean shouldExpandAsZip = false;
            if (zipEnabled) {
                shouldExpandAsZip = this.shouldExpandAsZip(issue, item.attachment());
            }
            boolean canDelete = this.helper.canDeleteAttachment(issue, item.attachment(), user);
            builder.add((Object)new SimpleAttachment(item.attachment(), latestVersion, shouldExpandAsZip, this.thumbnailManager.toThumbnailedImage(item.thumbnail()), canDelete));
        }
        return builder.asList();
    }

    private boolean shouldExpandAsZip(Issue issue, Attachment attachment) {
        if (attachment.isZip() != null) {
            return attachment.isZip();
        }
        String mimetype = attachment.getMimetype();
        boolean isZip = false;
        if (mimetype.startsWith("application")) {
            String attachmentExtension = FilenameUtils.getExtension((String)attachment.getFilename());
            if (this.nonZipExpandableExtensions.contains(attachmentExtension) || WELL_KNOWN_MIMETYPES.contains(mimetype)) {
                isZip = false;
            } else {
                File attachmentFile = AttachmentUtils.getAttachmentFile((Issue)issue, (Attachment)attachment);
                isZip = this.attachmentZipKit.isZip(attachmentFile);
            }
        }
        this.attachmentManager.setZip(attachment, isZip);
        return isZip;
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        User user = this.authenticationContext.getLoggedInUser();
        return issue.getId() + "/" + (user == null ? "" : user.getName());
    }

    private static HttpServletRequest getRequest(Map<String, Object> context) {
        return ((JiraHelper)context.get("helper")).getRequest();
    }

    static {
        WELL_KNOWN_MIMETYPES.add("application/pdf");
        WELL_KNOWN_MIMETYPES.add("application/msword");
    }

    public class IconGenerator {
        public SimpleIcon getIcon(SimpleAttachment attachment) {
            FileIconBean.FileIcon fileIcon = AttachmentBlockContextProvider.this.fileIconUtil.getFileIcon(attachment.getFilename(), attachment.getMimetype());
            return new SimpleIcon(fileIcon == null ? "file.gif" : fileIcon.getIcon(), fileIcon == null ? "File" : fileIcon.getAltText());
        }

        public SimpleIcon getIcon(AttachmentZipKit.AttachmentZipEntry zipEntry) {
            FileIconBean.FileIcon fileIcon = AttachmentBlockContextProvider.this.fileIconUtil.getFileIcon(zipEntry.getName(), null);
            return new SimpleIcon(fileIcon == null ? "file.gif" : fileIcon.getIcon(), fileIcon == null ? "File" : fileIcon.getAltText());
        }

        public class SimpleIcon {
            private final String icon;
            private final String altText;

            public SimpleIcon(String icon, String altText) {
                this.icon = icon;
                this.altText = altText;
            }

            public String getIcon() {
                return this.icon;
            }

            public String getAltText() {
                return this.altText;
            }
        }
    }

    public class SimpleAttachment {
        private final Attachment attachment;
        private final boolean isLatest;
        private final boolean exapandAsZip;
        private final ThumbnailedImage thumbnail;
        private boolean canDelete;
        private AttachmentZipKit.AttachmentZipEntries attachmentZipEntries;

        public SimpleAttachment(Attachment attachment, boolean latest, boolean exapandAsZip, ThumbnailedImage thumbnail, boolean canDelete) {
            this.attachment = attachment;
            this.isLatest = latest;
            this.exapandAsZip = exapandAsZip;
            this.thumbnail = thumbnail;
            this.canDelete = canDelete;
        }

        public boolean isLatest() {
            return this.isLatest;
        }

        public Long getId() {
            return this.attachment.getId();
        }

        public String getMimetype() {
            return MimetypesFileTypeMap.getContentType((String)this.getFilename());
        }

        public String getFilename() {
            return this.attachment.getFilename();
        }

        public String getFilenameUrlEncoded() {
            return JiraUrlCodec.encode((String)this.attachment.getFilename(), (boolean)true);
        }

        public String getCreatedFormatted() {
            return AttachmentBlockContextProvider.this.dateTimeFormatter.format((Date)this.attachment.getCreated());
        }

        public String getCreatedIso8601() {
            return AttachmentBlockContextProvider.this.dateTimeFormatter.withStyle(DateTimeStyle.ISO_8601_DATE_TIME).format((Date)this.attachment.getCreated());
        }

        public String getFilesize() {
            return FileSize.format((Long)this.attachment.getFilesize());
        }

        public String getAuthor() {
            return this.attachment.getAuthorKey();
        }

        public String getDisplayAuthor() {
            ApplicationUser user = AttachmentBlockContextProvider.this.userManager.getUserByKeyEvenWhenUnknown(this.attachment.getAuthorKey());
            return user != null ? user.getDisplayName() : null;
        }

        public boolean isExpandAsZip() {
            return this.exapandAsZip;
        }

        public ThumbnailedImage getThumbnail() {
            return this.thumbnail;
        }

        public boolean isCanDelete() {
            return this.canDelete;
        }

        public AttachmentZipKit.AttachmentZipEntries getZipEntries() {
            if (this.attachmentZipEntries == null) {
                try {
                    File attachmentFile = AttachmentUtils.getAttachmentFile((Attachment)this.attachment);
                    this.attachmentZipEntries = AttachmentBlockContextProvider.this.attachmentZipKit.listEntries(attachmentFile, AttachmentBlockContextProvider.this.helper.getMaximumNumberOfZipEntriesToShow(), AttachmentZipKit.FileCriteria.ONLY_FILES);
                    return this.attachmentZipEntries;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.attachmentZipEntries;
        }
    }
}

