/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.userprofile;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugins.userprofile.AbstractUserProfilePanel;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.VelocityParamFactory;
import com.atlassian.jira.web.bean.StatisticAccessorBean;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class AssignedAndOpenUserProfilePanel
extends AbstractUserProfilePanel {
    private final PermissionManager permissionManager;
    private final SearchService searchService;

    public AssignedAndOpenUserProfilePanel(JiraAuthenticationContext jiraAuthenticationContext, VelocityTemplatingEngine templatingEngine, VelocityParamFactory velocityParamFactory, PermissionManager permissionManager, SearchService searchService, JiraAuthenticationContext jiraAuthenticationContext1) {
        super(jiraAuthenticationContext);
        this.permissionManager = permissionManager;
        this.searchService = searchService;
    }

    public boolean showFragment(User profileUser, User currentUser) {
        return Iterables.any((Iterable)this.permissionManager.getProjectObjects(10, currentUser), (Predicate)Predicates.in((Collection)this.permissionManager.getProjectObjects(17, profileUser)));
    }

    public Map<String, Object> getContextMap(Map<String, Object> initialContext) {
        User profileUser = (User)initialContext.get("profileUser");
        User currentUser = (User)initialContext.get("currentUser");
        Map<String, Object> params = this.createVelocityParams(profileUser, currentUser);
        params.put("panelId", this.getId());
        params.put("projects", this.getProjects(profileUser, currentUser));
        params.put("urlBuilder", new UrlBuilder(profileUser, currentUser));
        return params;
    }

    @Override
    public String getId() {
        return "assigned-and-open";
    }

    private StatisticMapWrapper getProjects(User profileUser, User currentUser) {
        JqlClauseBuilder builder = this.getBaseQuery(profileUser, currentUser);
        SearchRequest request = new SearchRequest(builder.buildQuery());
        try {
            StatisticAccessorBean bean = new StatisticAccessorBean(currentUser, request);
            StatisticMapWrapper mapWrapper = bean.getAllFilterBy("project");
            return mapWrapper;
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
    }

    private JqlClauseBuilder getBaseQuery(User profileUser, User currentUser) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().unresolved();
        if (profileUser.equals(currentUser)) {
            builder.and().assigneeIsCurrentUser();
        } else {
            builder.and().assignee().eq(profileUser.getName());
        }
        return builder;
    }

    public class UrlBuilder {
        private final User profileUser;
        private final User currentUser;

        public UrlBuilder(User profileUser, User currentUser) {
            this.profileUser = profileUser;
            this.currentUser = currentUser;
        }

        public String getUrl(GenericValue project) {
            JqlClauseBuilder builder = AssignedAndOpenUserProfilePanel.this.getBaseQuery(this.profileUser, this.currentUser);
            builder.and().project(new Long[]{project.getLong("id")});
            return AssignedAndOpenUserProfilePanel.this.searchService.getQueryString(this.currentUser, builder.buildQuery());
        }
    }
}

