/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.share;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.mail.MailService;
import com.atlassian.jira.notification.AdhocNotificationService;
import com.atlassian.jira.notification.JiraNotificationReason;
import com.atlassian.jira.notification.NotificationBuilder;
import com.atlassian.jira.notification.NotificationFilterContext;
import com.atlassian.jira.notification.NotificationFilterManager;
import com.atlassian.jira.notification.NotificationReason;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.plugins.share.ShareBean;
import com.atlassian.jira.plugins.share.ShareService;
import com.atlassian.jira.plugins.share.event.ShareIssueEvent;
import com.atlassian.jira.plugins.share.event.ShareJqlEvent;
import com.atlassian.jira.plugins.share.event.ShareSearchRequestEvent;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class ShareServiceImpl
implements ShareService {
    private static final Logger log = Logger.getLogger(ShareServiceImpl.class);
    private final EventPublisher eventPublisher;
    private final I18nHelper.BeanFactory beanFactory;
    private final PermissionManager permissionManager;
    private final MailService mailService;
    private final ShareManager shareManager;
    private final UserManager userManager;
    private final AdhocNotificationService adhocNotificationService;
    private final NotificationFilterManager notificationFilterManager;

    public ShareServiceImpl(EventPublisher eventPublisher, I18nHelper.BeanFactory beanFactory, PermissionManager permissionManager, MailService mailService, ShareManager shareManager, AdhocNotificationService adhocNotificationService, NotificationFilterManager notificationFilterManager, UserManager userManager) {
        this.notificationFilterManager = notificationFilterManager;
        this.userManager = userManager;
        this.eventPublisher = (EventPublisher)Assertions.notNull((Object)eventPublisher);
        this.beanFactory = (I18nHelper.BeanFactory)Assertions.notNull((Object)beanFactory);
        this.permissionManager = (PermissionManager)Assertions.notNull((Object)permissionManager);
        this.mailService = (MailService)Assertions.notNull((Object)mailService);
        this.shareManager = (ShareManager)Assertions.notNull((Object)shareManager);
        this.adhocNotificationService = (AdhocNotificationService)Assertions.notNull((Object)adhocNotificationService);
    }

    @Override
    public ShareService.ValidateShareIssueResult validateShareIssue(User remoteUser, ShareBean shareBean, Issue issue) {
        ErrorCollection errors = this.validateShare(remoteUser, shareBean);
        return new ShareService.ValidateShareIssueResult(errors, remoteUser, shareBean, issue);
    }

    @Override
    public void shareIssue(ShareService.ValidateShareIssueResult result) {
        if (!result.isValid()) {
            throw new IllegalStateException("Validation result was not valid.");
        }
        Issue issue = result.getIssue();
        User from = result.getRemoteUser();
        ShareBean shareBean = result.getShareBean();
        this.adhocNotificationService.sendNotification(this.adhocNotificationService.validateNotification(this.makeNotificationBuilder(shareBean), from, issue, AdhocNotificationService.ValiationOption.CONTINUE_ON_NO_RECIPIENTS));
        this.eventPublisher.publish((Object)new ShareIssueEvent(issue, from, shareBean.getUsernames(), shareBean.getEmails(), shareBean.getMessage()));
    }

    @Override
    public ShareService.ValidateShareSearchRequestResult validateShareSearchRequest(User remoteUser, ShareBean shareBean, SearchRequest searchRequest) {
        ErrorCollection errors = this.validateShare(remoteUser, shareBean);
        return new ShareService.ValidateShareSearchRequestResult(errors, remoteUser, shareBean, searchRequest);
    }

    @Override
    public void shareSearchRequest(ShareService.ValidateShareSearchRequestResult result) {
        String jql;
        if (!result.isValid()) {
            throw new IllegalStateException("Validation result was not valid.");
        }
        HashMap params = Maps.newHashMap();
        params.put("remoteUser", result.getRemoteUser());
        SearchRequest searchRequest = result.getSearchRequest();
        if (searchRequest != null) {
            UrlBuilder savedSearchUrlBuilder = new UrlBuilder(false);
            savedSearchUrlBuilder.addParameter("mode", "hide");
            savedSearchUrlBuilder.addParameter("requestId", (Object)searchRequest.getId());
            params.put("savedSearchLinkUrlParams", savedSearchUrlBuilder.asUrlString());
            params.put("filterName", searchRequest.getName());
            jql = searchRequest.getQuery().getQueryString();
        } else {
            jql = result.shareBean.getJql();
        }
        UrlBuilder jqlUrlBuilder = new UrlBuilder(false);
        jqlUrlBuilder.addParameter("reset", (Object)true);
        jqlUrlBuilder.addParameter("jqlQuery", jql);
        params.put("jqlSearchLinkUrlParams", jqlUrlBuilder.asUrlString());
        String message = result.getShareBean().getMessage();
        if (StringUtils.isNotBlank((String)message)) {
            params.put("comment", message);
            params.put("htmlComment", TextUtils.htmlEncode((String)message));
        }
        this.sendShareSearchEmails(result, params);
        ShareBean shareSearchBean = result.getShareBean();
        if (searchRequest != null) {
            this.eventPublisher.publish((Object)new ShareSearchRequestEvent(result.getRemoteUser(), shareSearchBean.getUsernames(), shareSearchBean.getEmails(), shareSearchBean.getMessage(), searchRequest));
        } else {
            this.eventPublisher.publish((Object)new ShareJqlEvent(result.getRemoteUser(), shareSearchBean.getUsernames(), shareSearchBean.getEmails(), shareSearchBean.getMessage(), jql));
        }
    }

    private ErrorCollection validateShare(User remoteUser, ShareBean shareBean) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18nHelper = this.beanFactory.getInstance(remoteUser);
        if (shareBean.getUsernames().isEmpty() && shareBean.getEmails().isEmpty()) {
            errors.addErrorMessage(i18nHelper.getText("jira-share-plugin.no.users.or.emails.provided"));
        }
        if (!this.permissionManager.hasPermission(27, remoteUser)) {
            errors.addErrorMessage(i18nHelper.getText("jira-share-plugin.no.permission.to.browse.users"));
        }
        return errors;
    }

    private NotificationBuilder makeNotificationBuilder(ShareBean shareBean) {
        NotificationBuilder notificationBuilder = this.adhocNotificationService.makeBuilder();
        if (shareBean.getUsernames() != null) {
            notificationBuilder.addToUsers((List)Lists.newArrayList(shareBean.getUsernames()));
        }
        if (shareBean.getEmails() != null) {
            notificationBuilder.addToEmails((List)Lists.newArrayList(shareBean.getEmails()));
        }
        notificationBuilder.setTemplate("share-issue.vm");
        ImmutableMap.Builder params = ImmutableMap.builder();
        String message = shareBean.getMessage();
        if (StringUtils.isNotBlank((String)message)) {
            params.put((Object)"comment", (Object)message);
            params.put((Object)"htmlComment", (Object)TextUtils.htmlEncode((String)message));
        }
        notificationBuilder.setTemplateParams(params.build());
        return notificationBuilder;
    }

    private void sendShareSearchEmails(ShareService.ValidateShareSearchRequestResult result, Map<String, Object> params) {
        User from = result.getRemoteUser();
        ShareBean shareBean = result.getShareBean();
        SearchRequest searchRequest = result.getSearchRequest();
        List<NotificationRecipient> recipients = this.getRecipients(shareBean);
        NotificationFilterContext context = this.notificationFilterManager.makeContextFrom((NotificationReason)JiraNotificationReason.SHARED);
        for (NotificationRecipient recipient : recipients) {
            if (this.notificationFilterManager.filtered(recipient, context)) continue;
            ApplicationUser userRecipient = recipient.getUser();
            boolean shareSavedSearch = searchRequest != null && userRecipient != null && this.shareManager.isSharedWith(userRecipient, (SharedEntity)searchRequest);
            String template = shareSavedSearch ? "share-saved-search.vm" : "share-jql-search.vm";
            String subjectTemplatePath = "templates/email/subject/" + template;
            String bodyTemplatePath = "templates/email/" + recipient.getFormat() + '/' + template;
            this.mailService.sendRenderedMail(from, recipient, subjectTemplatePath, bodyTemplatePath, params);
        }
    }

    private List<NotificationRecipient> getRecipients(ShareBean shareBean) {
        ArrayList recipients = Lists.newArrayList();
        if (shareBean.getUsernames() != null) {
            for (String toUsername : shareBean.getUsernames()) {
                ApplicationUser user = this.userManager.getUserByName(toUsername);
                if (user != null) {
                    recipients.add(new NotificationRecipient(user));
                    continue;
                }
                log.warn((Object)("No user found for name: " + toUsername));
            }
        }
        if (shareBean.getEmails() != null) {
            for (String toEmail : shareBean.getEmails()) {
                recipients.add(new NotificationRecipient(toEmail));
            }
        }
        return recipients;
    }
}

