/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.jira.issue.comparator.UserBestNameComparator;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.api.expand.PagedListWrapper;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.rest.v2.search.UserListResolver;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;

public class UserBeanListWrapper
extends PagedListWrapper<UserBean, ApplicationUser> {
    private final Ordering<ApplicationUser> userOrdering = Ordering.from((Comparator)new UserBestNameComparator());
    private final JiraBaseUrls jiraBaseUrls;
    private final UserListResolver userListResolver;

    private UserBeanListWrapper() {
        this(null, null, 0);
    }

    public UserBeanListWrapper(JiraBaseUrls jiraBaseUrls, UserListResolver userListResolver, int maxResults) {
        super(0, maxResults);
        this.jiraBaseUrls = jiraBaseUrls;
        this.userListResolver = userListResolver;
    }

    @Override
    public UserBean fromBackedObject(ApplicationUser user) {
        return new UserBeanBuilder(this.jiraBaseUrls).user(user).buildShort();
    }

    @Override
    public int getBackingListSize() {
        return this.userListResolver.getShareCount();
    }

    @Override
    public List<ApplicationUser> getOrderedList(int startIndex, int endIndex) {
        List sortedUsers = this.userOrdering.leastOf(this.userListResolver.getShareUsers(), endIndex + 1);
        return sortedUsers.subList(startIndex, endIndex + 1);
    }
}

