/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.rest.v2.search.SharePermissionInputBean;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SharePermissionInputBeanValidator {
    public ServiceResult validateAddPermissionBean(SharePermissionInputBean inputBean, I18nHelper i18nHelper) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        String typeString = inputBean.getType();
        Optional<SharePermissionInputBean.Type> maybeType = SharePermissionInputBean.Type.fromValue(typeString);
        if (!maybeType.isPresent()) {
            errorCollection.addErrorMessage(i18nHelper.getText("rest.filters.add.permission.invalid.type", SharePermissionInputBeanValidator.sharePermissionTypesString()));
        } else {
            SharePermissionInputBean.Type type = maybeType.get();
            switch (type) {
                case PROJECT: {
                    if (inputBean.getProjectId() != null) break;
                    errorCollection.addErrorMessage(i18nHelper.getText("rest.filters.add.permission.no.project.id.given"));
                    break;
                }
                case GROUP: {
                    if (inputBean.getGroupname() != null) break;
                    errorCollection.addErrorMessage(i18nHelper.getText("rest.filters.add.permission.no.group.name.given"));
                    break;
                }
                case PROJECT_ROLE: {
                    if (inputBean.getProjectRoleId() != null) break;
                    errorCollection.addErrorMessage(i18nHelper.getText("rest.filters.add.permission.no.project.role.id.given"));
                    break;
                }
                case USER: {
                    if (inputBean.getUserKey() != null) break;
                    errorCollection.addErrorMessage(i18nHelper.getText("rest.filters.add.permission.no.user.key.given"));
                }
            }
        }
        return new ServiceResultImpl((ErrorCollection)errorCollection);
    }

    private static String sharePermissionTypesString() {
        return "[" + StringUtils.join((Object[])SharePermissionInputBean.Type.values(), (String)", ") + "]";
    }
}

