/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.jira.bc.filter.FilterSubscriptionService;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBeanBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.subscription.FilterSubscription;
import com.atlassian.jira.rest.api.expand.PagedListWrapper;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.rest.v2.search.FilterSubscriptionBean;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.opensymphony.util.TextUtils;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class FilterSubscriptionBeanListWrapper
extends PagedListWrapper<FilterSubscriptionBean, FilterSubscription> {
    private FilterSubscriptionService filterSubscriptionService;
    private SearchRequest filter;
    private ApplicationUser user;
    private UserManager userManager;
    private JiraBaseUrls jiraBaseUrls;
    private LazyReference<Collection<FilterSubscription>> visibleSubscriptionsReference = new LazyReference<Collection<FilterSubscription>>(){

        protected Collection<FilterSubscription> create() throws Exception {
            return FilterSubscriptionBeanListWrapper.this.filterSubscriptionService.getVisibleFilterSubscriptions(FilterSubscriptionBeanListWrapper.this.user, FilterSubscriptionBeanListWrapper.this.filter);
        }
    };

    public FilterSubscriptionBeanListWrapper(FilterSubscriptionService filterSubscriptionService, UserManager userManager, ApplicationUser user, SearchRequest filter, JiraBaseUrls jiraBaseUrls) {
        super(0, 1000);
        this.filter = filter;
        this.filterSubscriptionService = filterSubscriptionService;
        this.user = user;
        this.userManager = userManager;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    private FilterSubscriptionBeanListWrapper() {
        super(0, 0);
    }

    public static FilterSubscriptionBeanListWrapper empty() {
        return new FilterSubscriptionBeanListWrapper(null, null, null, null, null);
    }

    @Override
    public FilterSubscriptionBean fromBackedObject(FilterSubscription filterSubscription) {
        return new FilterSubscriptionBeanBuilder().subscription(filterSubscription).build();
    }

    @Override
    public int getBackingListSize() {
        return ((Collection)this.visibleSubscriptionsReference.get()).size();
    }

    @Override
    public List<FilterSubscription> getOrderedList(int startIndex, int endIndex) {
        ImmutableList subscriptions = Ordering.from((Comparator)WithId.ID_COMPARATOR).immutableSortedCopy((Iterable)this.visibleSubscriptionsReference.get());
        return subscriptions.subList(startIndex, endIndex + 1);
    }

    class FilterSubscriptionBeanBuilder {
        private FilterSubscription subscription;

        FilterSubscriptionBeanBuilder() {
        }

        public FilterSubscriptionBeanBuilder subscription(FilterSubscription subscription) {
            this.subscription = subscription;
            return this;
        }

        private UserBean buildUserBean() {
            String userKey = this.subscription.getUserKey();
            return new UserBeanBuilder(FilterSubscriptionBeanListWrapper.this.jiraBaseUrls).user(FilterSubscriptionBeanListWrapper.this.userManager.getUserByKey(userKey)).buildShort();
        }

        private GroupJsonBean buildGroupBean() {
            String groupName = this.subscription.getGroupName();
            return this.validGroupName(groupName) ? new GroupJsonBeanBuilder(FilterSubscriptionBeanListWrapper.this.jiraBaseUrls).name(groupName).build() : null;
        }

        private boolean validGroupName(String groupName) {
            return TextUtils.stringSet((String)groupName) && FilterSubscriptionBeanListWrapper.this.userManager.getGroup(groupName) != null;
        }

        public FilterSubscriptionBean build() {
            return new FilterSubscriptionBean(this.subscription.getId(), this.buildUserBean(), this.buildGroupBean());
        }
    }
}

