/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.fields.ColumnService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.event.mau.MauApplicationKey;
import com.atlassian.jira.event.mau.MauEventService;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.fields.layout.column.EditableSearchRequestColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableSearchRequestColumnLayoutImpl;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.util.FilterPermissionHelper;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.rest.v2.search.ColumnOptions;
import com.atlassian.jira.rest.v2.search.DefaultShareScopeBean;
import com.atlassian.jira.rest.v2.search.FilterBean;
import com.atlassian.jira.rest.v2.search.FilterPermissionBean;
import com.atlassian.jira.rest.v2.search.FilterPermissionBeanFactory;
import com.atlassian.jira.rest.v2.search.SharePermissionFactory;
import com.atlassian.jira.rest.v2.search.SharePermissionInputBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.util.UserSharingPreferencesUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugins.rest.common.expand.EntityCrawler;
import com.atlassian.plugins.rest.common.expand.parameter.DefaultExpandParameter;
import com.atlassian.plugins.rest.common.expand.parameter.ExpandParameter;
import com.atlassian.plugins.rest.common.expand.resolver.EntityExpanderResolver;
import com.atlassian.plugins.rest.common.expand.resolver.ListWrapperEntityExpanderResolver;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.query.Query;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;

@Path(value="filter")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class FilterResource {
    private final JiraAuthenticationContext authenticationContext;
    private final SearchRequestService searchRequestService;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final FavouritesService favouritesService;
    private final SearchService searchService;
    private final BeanBuilderFactory beanBuilderFactory;
    private final UserSharingPreferencesUtil userSharingPreferencesUtil;
    private final PermissionManager permissionsManager;
    private final UserPreferencesManager userPreferencesManager;
    private final ColumnLayoutManager columnLayoutManager;
    private final ColumnService columnService;
    private final FilterPermissionBeanFactory filterPermissionBeanFactory;
    private final ResponseFactory responseFactory;
    private final SharePermissionFactory sharePermissionFactory;
    private final FilterPermissionHelper filterPermissionHelper;
    private final MauEventService mauEventService;

    public FilterResource(JiraAuthenticationContext authenticationContext, SearchRequestService searchRequestService, VelocityRequestContextFactory velocityRequestContextFactory, FavouritesService favouritesService, SearchService searchService, BeanBuilderFactory beanBuilderFactory, UserSharingPreferencesUtil userSharingPreferencesUtil, PermissionManager permissionsManager, UserPreferencesManager userPreferencesManager, ColumnLayoutManager columnLayoutManager, ColumnService columnService, FilterPermissionBeanFactory filterPermissionBeanFactory, ResponseFactory responseFactory, SharePermissionFactory sharePermissionFactory, FilterPermissionHelper filterPermissionHelper, MauEventService mauEventService) {
        this.authenticationContext = authenticationContext;
        this.searchRequestService = searchRequestService;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.favouritesService = favouritesService;
        this.searchService = searchService;
        this.beanBuilderFactory = beanBuilderFactory;
        this.userSharingPreferencesUtil = userSharingPreferencesUtil;
        this.permissionsManager = permissionsManager;
        this.userPreferencesManager = userPreferencesManager;
        this.columnLayoutManager = columnLayoutManager;
        this.columnService = columnService;
        this.filterPermissionBeanFactory = filterPermissionBeanFactory;
        this.responseFactory = responseFactory;
        this.sharePermissionFactory = sharePermissionFactory;
        this.filterPermissionHelper = filterPermissionHelper;
        this.mauEventService = mauEventService;
    }

    @Path(value="{id}")
    @GET
    @ResponseType(value=FilterBean.class)
    public Response getFilter(@PathParam(value="id") Long id, @Context UriInfo uriInfo, @QueryParam(value="expand") StringList expand) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)context, id);
        if (filter == null) {
            return this.responseFactory.errorResponse(context.getErrorCollection());
        }
        this.mauEventService.setApplicationForThread(MauApplicationKey.family());
        return this.responseFactory.okNoCache(new SearchRequestToFilterBean(uriInfo, expand).apply(filter));
    }

    @POST
    @RequestType(value=FilterBean.class)
    @ResponseType(value=FilterBean.class)
    public Response createFilter(final FilterBean bean, final @Context UriInfo uriInfo, final @QueryParam(value="expand") StringList expand) {
        final ApplicationUser user = this.authenticationContext.getLoggedInUser();
        final JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        if (user == null) {
            return this.responseFactory.notLoggedInResponse();
        }
        SearchRequest copiedFromFilter = null;
        Query queryToCopy = null;
        if (bean.getId() != null) {
            copiedFromFilter = this.searchRequestService.getFilter((JiraServiceContext)context, Long.valueOf(Long.parseLong(bean.getId())));
            if (copiedFromFilter == null) {
                return this.responseFactory.errorResponse(context.getErrorCollection());
            }
            if (bean.getJql() == null) {
                queryToCopy = copiedFromFilter.getQuery();
            }
        }
        if (queryToCopy == null) {
            SearchService.ParseResult parseResult = this.parseAndValidateJql(bean.getJql(), null, user, (JiraServiceContext)context);
            queryToCopy = parseResult.getQuery();
        }
        Either<Response, SearchRequest> responseSearchRequestEither = this.processFilterBeanForCreate(bean, queryToCopy, (JiraServiceContext)context);
        final SearchRequest finalCopiedFromFilter = copiedFromFilter;
        this.mauEventService.setApplicationForThread(MauApplicationKey.family());
        return (Response)responseSearchRequestEither.left().on((java.util.function.Function)new java.util.function.Function<SearchRequest, Response>(){

            @Override
            @Nullable
            public Response apply(SearchRequest newFilter) {
                if (newFilter == null) {
                    return FilterResource.this.responseFactory.errorResponse(context.getErrorCollection());
                }
                newFilter = FilterResource.this.searchRequestService.createFilter((JiraServiceContext)new JiraServiceContextImpl(user), newFilter, bean.isFavourite());
                if (finalCopiedFromFilter != null) {
                    FilterResource.this.applyFilterColumnsToFilter(finalCopiedFromFilter, newFilter);
                }
                return FilterResource.this.getFilter(newFilter.getId(), uriInfo, expand);
            }
        });
    }

    @PUT
    @RequestType(value=FilterBean.class)
    @ResponseType(value=FilterBean.class)
    @Path(value="{id}")
    public Response editFilter(@PathParam(value="id") Long filterId, FilterBean bean, @Context UriInfo uriInfo, @QueryParam(value="expand") StringList expand) {
        SearchService.ParseResult parseResult;
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (user == null) {
            return this.responseFactory.notLoggedInResponse();
        }
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        SearchRequest searchRequest = this.searchRequestService.getFilter((JiraServiceContext)context, filterId);
        if (bean.getJql() != null && (parseResult = this.parseAndValidateJql(bean.getJql(), filterId, user, (JiraServiceContext)context)).isValid()) {
            searchRequest.setQuery(parseResult.getQuery());
        }
        if (bean.getName() != null) {
            searchRequest.setName(bean.getName());
        }
        if (bean.getDescription() != null) {
            searchRequest.setDescription(bean.getDescription());
        }
        this.searchRequestService.validateFilterForUpdate((JiraServiceContext)context, searchRequest);
        if (context.getErrorCollection().hasAnyErrors()) {
            return this.responseFactory.errorResponse(context.getErrorCollection());
        }
        this.searchRequestService.updateFilter((JiraServiceContext)context, searchRequest);
        this.mauEventService.setApplicationForThread(MauApplicationKey.family());
        return this.getFilter(searchRequest.getId(), uriInfo, expand);
    }

    @DELETE
    @Path(value="{id}")
    public Response deleteFilter(@PathParam(value="id") Long id) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        this.searchRequestService.deleteFilter((JiraServiceContext)context, id);
        if (context.getErrorCollection().hasAnyErrors()) {
            return this.responseFactory.errorResponse(context.getErrorCollection());
        }
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    private void applyFilterColumnsToFilter(SearchRequest filter, SearchRequest newFilter) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (filter != null) {
            try {
                ColumnLayout filterColumnLayout = this.columnLayoutManager.getColumnLayout(user, filter);
                if (filterColumnLayout != null) {
                    this.columnLayoutManager.storeEditableSearchRequestColumnLayout((EditableSearchRequestColumnLayout)new EditableSearchRequestColumnLayoutImpl(filterColumnLayout.getColumnLayoutItems(), user, newFilter));
                }
            }
            catch (ColumnLayoutStorageException e) {
                throw new RuntimeException("Failed to store column layout for filter [" + newFilter.getId() + "]", e);
            }
        }
    }

    private Either<Response, SearchRequest> processFilterBeanForCreate(FilterBean bean, Query query, JiraServiceContext context) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
        SearchRequest request = new SearchRequest(query);
        if (StringUtils.isBlank((CharSequence)bean.getName())) {
            context.getErrorCollection().addError("filterName", i18nHelper.getText("saveasfilter.specify.name"));
        }
        request.setName(bean.getName());
        request.setOwner(user);
        request.setDescription(bean.getDescription());
        request.setPermissions(SharedEntity.SharePermissions.PRIVATE);
        if (this.isEditEnabled()) {
            request.setPermissions(this.userSharingPreferencesUtil.getDefaultSharePermissions(user));
        }
        this.searchRequestService.validateFilterForCreate(context, request);
        if (context.getErrorCollection().hasAnyErrors()) {
            return Either.left((Object)this.responseFactory.errorResponse(context.getErrorCollection()));
        }
        return Either.right((Object)request);
    }

    private SearchService.ParseResult parseAndValidateJql(String jql, Long filterId, ApplicationUser user, JiraServiceContext context) {
        SearchService.ParseResult parseResult = this.searchService.parseQuery(user, jql);
        if (!parseResult.isValid()) {
            context.getErrorCollection().addErrorMessages((Collection)parseResult.getErrors().getErrorMessages());
        } else {
            MessageSet validationResults = this.searchService.validateQuery(user, parseResult.getQuery(), filterId);
            if (validationResults.hasAnyErrors()) {
                context.getErrorCollection().addErrorMessages((Collection)validationResults.getErrorMessages());
            }
        }
        return parseResult;
    }

    @Path(value="favourite")
    @GET
    @ResponseType(value=List.class, genericTypes={FilterBean.class})
    public List<FilterBean> getFavouriteFilters(@Context UriInfo uriInfo, @QueryParam(value="expand") StringList expand) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        Collection favouriteFilters = this.searchRequestService.getFavouriteFilters(user);
        Iterable favouriteFilterBeans = Iterables.transform((Iterable)favouriteFilters, (Function)new SearchRequestToFilterBean(uriInfo, expand, true));
        return Lists.newArrayList((Iterable)favouriteFilterBeans);
    }

    @Path(value="defaultShareScope")
    @GET
    @ResponseType(value=DefaultShareScopeBean.class)
    public Response getDefaultShareScope() {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (user == null) {
            return this.responseFactory.notLoggedInResponse();
        }
        DefaultShareScopeBean shareScope = this.isEditEnabled() && this.userSharingPreferencesUtil.getDefaultSharePermissions(user).isGlobal() ? new DefaultShareScopeBean(DefaultShareScopeBean.Scope.GLOBAL) : (this.isEditEnabled() && this.userSharingPreferencesUtil.getDefaultSharePermissions(user).isAuthenticated() ? new DefaultShareScopeBean(DefaultShareScopeBean.Scope.AUTHENTICATED) : new DefaultShareScopeBean(DefaultShareScopeBean.Scope.PRIVATE));
        return this.responseFactory.okNoCache(shareScope);
    }

    @Path(value="defaultShareScope")
    @PUT
    @RequestType(value=DefaultShareScopeBean.class)
    @ResponseType(value=DefaultShareScopeBean.class)
    public Response setDefaultShareScope(DefaultShareScopeBean shareScope) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (user == null) {
            return this.responseFactory.notLoggedInResponse();
        }
        Preferences userPreferences = this.userPreferencesManager.getPreferences(user);
        try {
            boolean defaultToPrivate = DefaultShareScopeBean.Scope.PRIVATE.equals((Object)shareScope.getScope());
            userPreferences.setBoolean("user.default.share.private", defaultToPrivate);
        }
        catch (AtlassianCoreException e) {
            return this.responseFactory.notLoggedInResponse();
        }
        return this.getDefaultShareScope();
    }

    @GET
    @ResponseType(value=List.class, genericTypes={ColumnOptions.ColumnItem.class})
    @Path(value="{id}/columns")
    public Response defaultColumns(@PathParam(value="id") Long filterId) {
        ApplicationUser currentUser = this.authenticationContext.getLoggedInUser();
        ServiceOutcome outcome = this.columnService.getColumnLayout(currentUser, filterId);
        if (outcome.isValid()) {
            ColumnLayout columnLayout = (ColumnLayout)outcome.getReturnedValue();
            if (columnLayout == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
            }
            List columnLayoutItems = columnLayout.getColumnLayoutItems();
            return this.responseFactory.okNoCache(ColumnOptions.toColumnOptions(columnLayoutItems));
        }
        return this.responseFactory.errorResponse(outcome.getErrorCollection());
    }

    @PUT
    @Path(value="{id}/columns")
    @Consumes(value={"*/*"})
    @ResponseType(value=Void.class)
    public Response setColumns(@PathParam(value="id") Long filterId, @FormParam(value="columns") List<String> fields) {
        ApplicationUser currentUser = this.authenticationContext.getLoggedInUser();
        ServiceResult outcome = this.columnService.setColumns(currentUser, filterId, fields);
        if (outcome.isValid()) {
            return Response.ok().cacheControl(CacheControl.never()).build();
        }
        return this.responseFactory.errorResponse(outcome.getErrorCollection());
    }

    @DELETE
    @Path(value="{id}/columns")
    @Consumes(value={"*/*"})
    public Response resetColumns(@PathParam(value="id") Long filterId) {
        ApplicationUser currentUser = this.authenticationContext.getLoggedInUser();
        ServiceResult outcome = this.columnService.resetColumns(currentUser, filterId);
        if (outcome.isValid()) {
            return Response.noContent().cacheControl(CacheControl.never()).build();
        }
        return this.responseFactory.errorResponse(outcome.getErrorCollection());
    }

    @GET
    @Path(value="{id}/permission")
    @ResponseType(value=List.class, genericTypes={FilterPermissionBean.class})
    public Response getSharePermissions(@PathParam(value="id") Long id) {
        ApplicationUser currentUser = this.authenticationContext.getLoggedInUser();
        if (currentUser == null) {
            return this.responseFactory.notLoggedInResponse();
        }
        return this.withJiraServiceContext(context -> this.withFilter(id, (JiraServiceContext)context, filter -> {
            Collection<FilterPermissionBean> beans = this.getSharePermissionBeans(currentUser, (SearchRequest)filter);
            return Response.ok(beans).build();
        }));
    }

    private Collection<FilterPermissionBean> getSharePermissionBeans(ApplicationUser user, SearchRequest filter) {
        Set permissionSet = filter.getPermissions().getPermissionSet();
        return permissionSet.stream().map(permission -> this.filterPermissionBeanFactory.buildPermissionBean(user, (SharePermission)permission)).collect(Collectors.toList());
    }

    @GET
    @Path(value="{id}/permission/{permissionId}")
    @ResponseType(value=FilterPermissionBean.class)
    public Response getSharePermission(@PathParam(value="id") Long id, @PathParam(value="permissionId") Long permissionId) {
        ApplicationUser currentUser = this.authenticationContext.getLoggedInUser();
        if (currentUser == null) {
            return this.responseFactory.notLoggedInResponse();
        }
        return this.withJiraServiceContext(context -> this.withFilter(id, (JiraServiceContext)context, filter -> {
            Set permissionSet = filter.getPermissions().getPermissionSet();
            return permissionSet.stream().filter(sharePermission -> sharePermission.getId().equals(permissionId)).map(permission -> this.filterPermissionBeanFactory.buildPermissionBean(currentUser, (SharePermission)permission)).findFirst().map(this.responseFactory::okNoCache).orElse(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        }));
    }

    @POST
    @Path(value="{id}/permission")
    @ResponseType(value=List.class, genericTypes={FilterPermissionBean.class})
    public Response addSharePermission(SharePermissionInputBean sharePermissionInputBean, @PathParam(value="id") Long id) {
        ApplicationUser currentUser = this.authenticationContext.getLoggedInUser();
        if (currentUser == null) {
            return this.responseFactory.notLoggedInResponse();
        }
        return this.withJiraServiceContext(context -> this.withFilter(id, (JiraServiceContext)context, filter -> {
            ServiceOutcome<SharePermission> sharePermissionOutcome = this.sharePermissionFactory.fromBean(sharePermissionInputBean, context.getI18nBean());
            if (!sharePermissionOutcome.isValid()) {
                return this.responseFactory.errorResponse(sharePermissionOutcome.getErrorCollection());
            }
            ServiceOutcome<SearchRequest> outcome = this.filterPermissionHelper.addSharePermissionToSavedFilter(currentUser, (SearchRequest)filter, (SharePermission)sharePermissionOutcome.get());
            if (!outcome.isValid()) {
                return this.responseFactory.errorResponse(outcome.getErrorCollection());
            }
            return Response.status((Response.Status)Response.Status.CREATED).entity(this.getSharePermissionBeans(currentUser, (SearchRequest)outcome.get())).build();
        }));
    }

    @DELETE
    @Path(value="{id}/permission/{permission-id}")
    public Response deleteSharePermission(@PathParam(value="id") Long id, @PathParam(value="permission-id") Long permissionId) {
        return this.withJiraServiceContext(context -> this.withFilter(id, (JiraServiceContext)context, filter -> {
            ServiceOutcome<SearchRequest> outcome = this.filterPermissionHelper.removeSharePermissionFromSavedFilter(context.getLoggedInApplicationUser(), (SearchRequest)filter, permissionId);
            if (!outcome.isValid()) {
                return this.responseFactory.errorResponse(outcome.getErrorCollection());
            }
            return Response.noContent().build();
        }));
    }

    private Response withFilter(Long id, JiraServiceContext context, java.util.function.Function<SearchRequest, Response> responseFunction) {
        SearchRequest filter = this.searchRequestService.getFilter(context, id);
        if (filter == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return responseFunction.apply(filter);
    }

    private <T> T withJiraServiceContext(java.util.function.Function<JiraServiceContext, T> responseFunction) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        return responseFunction.apply((JiraServiceContext)context);
    }

    private boolean isEditEnabled() {
        return this.permissionsManager.hasPermission(22, this.authenticationContext.getLoggedInUser());
    }

    private class SearchRequestToFilterBean
    implements Function<SearchRequest, FilterBean> {
        private final UriInfo uriInfo;
        private final ExpandParameter expand;
        private final Boolean isFavourite;
        private final EntityExpanderResolver expandResolver = new ListWrapperEntityExpanderResolver();
        private final EntityCrawler entityCrawler = new EntityCrawler();

        public SearchRequestToFilterBean(UriInfo uriInfo, StringList expand) {
            this(uriInfo, expand, null);
        }

        public SearchRequestToFilterBean(UriInfo uriInfo, StringList expand, Boolean isFavourite) {
            this.uriInfo = uriInfo;
            this.expand = new DefaultExpandParameter(expand != null ? expand.asList() : Collections.emptyList());
            this.isFavourite = isFavourite;
        }

        public FilterBean apply(SearchRequest filter) {
            ApplicationUser loggedInUser = FilterResource.this.authenticationContext.getLoggedInUser();
            String canonicalBaseUrl = FilterResource.this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
            boolean isFavourite = this.isFavourite == null ? loggedInUser != null && FilterResource.this.favouritesService.isFavourite(loggedInUser, (SharedEntity)filter) : this.isFavourite;
            FilterBean bean = FilterResource.this.beanBuilderFactory.newFilterBeanBuilder().filter(filter).context(this.uriInfo, canonicalBaseUrl).owner(filter.getOwner()).favourite(isFavourite).build();
            this.entityCrawler.crawl((Object)bean, this.expand, this.expandResolver);
            return bean;
        }
    }
}

