/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.project.type;

import com.atlassian.jira.project.type.ProjectType;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeManager;
import com.atlassian.jira.rest.v2.project.type.ProjectTypeBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.rest.annotation.ResponseType;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="project/type")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
public class ProjectTypeResource {
    private final ProjectTypeManager projectTypeManager;
    private final JiraAuthenticationContext authenticationContext;

    public ProjectTypeResource(ProjectTypeManager projectTypeManager, JiraAuthenticationContext authenticationContext) {
        this.projectTypeManager = (ProjectTypeManager)Preconditions.checkNotNull((Object)projectTypeManager);
        this.authenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext);
    }

    @GET
    @ResponseType(value=List.class, genericTypes={ProjectTypeBean.class})
    public Response getAllProjectTypes() {
        return Response.ok((Object)Lists.newArrayList((Iterable)Iterables.transform((Iterable)this.projectTypeManager.getAllProjectTypes(), (Function)new Function<ProjectType, ProjectTypeBean>(){

            public ProjectTypeBean apply(@Nullable ProjectType projectType) {
                return ProjectTypeResource.this.toBean(projectType);
            }
        }))).build();
    }

    @GET
    @Path(value="{projectTypeKey}")
    @ResponseType(value=ProjectTypeBean.class)
    public Response getProjectTypeByKey(@PathParam(value="projectTypeKey") String projectTypeKey) {
        Option projectType = this.projectTypeManager.getByKey(new ProjectTypeKey(projectTypeKey));
        if (projectType.isDefined()) {
            return Response.ok((Object)this.toBean((ProjectType)projectType.get())).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="{projectTypeKey}/accessible")
    @ResponseType(value=ProjectTypeBean.class)
    public Response getAccessibleProjectTypeByKey(@PathParam(value="projectTypeKey") String projectTypeKey) {
        if (this.authenticationContext.isLoggedInUser()) {
            Option projectType = this.projectTypeManager.getAccessibleProjectType(this.authenticationContext.getLoggedInUser(), new ProjectTypeKey(projectTypeKey));
            if (projectType.isDefined()) {
                return Response.ok((Object)this.toBean((ProjectType)projectType.get())).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    private ProjectTypeBean toBean(ProjectType projectType) {
        return new ProjectTypeBean(projectType.getKey().getKey(), projectType.getDescriptionI18nKey(), projectType.getIcon(), projectType.getColor());
    }
}

