/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.permission;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.permission.PermissionScheme;
import com.atlassian.jira.permission.PermissionSchemeService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.permission.PermissionGrantBeanExpander;
import com.atlassian.jira.rest.api.permission.PermissionSchemeBean;
import com.atlassian.jira.rest.api.permission.PermissionSchemeBeansFactory;
import com.atlassian.jira.rest.api.permission.PermissionSchemeExpandParam;
import com.atlassian.jira.rest.util.ProjectFinder;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.common.IdBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.rest.annotation.ResponseType;
import java.util.List;
import java.util.function.Function;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="project/{projectKeyOrId}/permissionscheme")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public final class ProjectPermissionSchemeResource {
    private final PermissionSchemeService permissionSchemeService;
    private final ProjectFinder projectFinder;
    private final ResponseFactory responseFactory;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionSchemeBeansFactory beansFactory;
    private final PermissionGrantBeanExpander expander;

    public ProjectPermissionSchemeResource(PermissionSchemeService permissionSchemeService, ProjectFinder projectFinder, ResponseFactory responseFactory, JiraAuthenticationContext jiraAuthenticationContext, PermissionSchemeBeansFactory beansFactory, PermissionGrantBeanExpander expander) {
        this.permissionSchemeService = permissionSchemeService;
        this.projectFinder = projectFinder;
        this.responseFactory = responseFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.beansFactory = beansFactory;
        this.expander = expander;
    }

    @PUT
    @ResponseType(value=PermissionSchemeBean.class)
    public Response assignPermissionScheme(final @PathParam(value="projectKeyOrId") String projectKeyOrId, final IdBean permissionSchemeId, @QueryParam(value="expand") String expand) {
        return (Response)this.responseFactory.toResponse(this.expander.parseExpandQuery(expand)).left().on((Function)new Function<List<PermissionSchemeExpandParam>, Response>(){

            @Override
            public Response apply(final List<PermissionSchemeExpandParam> expands) {
                final ApplicationUser user = ProjectPermissionSchemeResource.this.jiraAuthenticationContext.getUser();
                ProjectService.GetProjectResult projectGetResult = ProjectPermissionSchemeResource.this.projectFinder.getGetProjectForActionByIdOrKey(user, projectKeyOrId, ProjectAction.VIEW_PROJECT);
                return (Response)ProjectPermissionSchemeResource.this.responseFactory.validateOutcome(projectGetResult).left().on((Function)new Function<Project, Response>(){

                    @Override
                    public Response apply(Project project) {
                        ServiceResult serviceResult = ProjectPermissionSchemeResource.this.permissionSchemeService.assignPermissionSchemeToProject(user, permissionSchemeId.getId(), project.getId());
                        if (serviceResult.isValid()) {
                            return ProjectPermissionSchemeResource.this.getProjectPermissionScheme(user, project, expands);
                        }
                        return ProjectPermissionSchemeResource.this.responseFactory.errorResponse(serviceResult.getErrorCollection());
                    }
                });
            }
        });
    }

    @GET
    @ResponseType(value=PermissionSchemeBean.class)
    public Response getAssignedPermissionScheme(final @PathParam(value="projectKeyOrId") String projectKeyOrId, @QueryParam(value="expand") String expand) {
        return (Response)this.responseFactory.toResponse(this.expander.parseExpandQuery(expand)).left().on((Function)new Function<List<PermissionSchemeExpandParam>, Response>(){

            @Override
            public Response apply(final List<PermissionSchemeExpandParam> expands) {
                final ApplicationUser user = ProjectPermissionSchemeResource.this.jiraAuthenticationContext.getUser();
                ProjectService.GetProjectResult projectGetResult = ProjectPermissionSchemeResource.this.projectFinder.getGetProjectForActionByIdOrKey(user, projectKeyOrId, ProjectAction.VIEW_PROJECT);
                return (Response)ProjectPermissionSchemeResource.this.responseFactory.validateOutcome(projectGetResult).left().on((Function)new Function<Project, Response>(){

                    @Override
                    public Response apply(Project project) {
                        return ProjectPermissionSchemeResource.this.getProjectPermissionScheme(user, project, expands);
                    }
                });
            }
        });
    }

    private Response getProjectPermissionScheme(ApplicationUser user, Project project, final List<PermissionSchemeExpandParam> expands) {
        return (Response)this.responseFactory.validateOutcome(this.permissionSchemeService.getSchemeAssignedToProject(user, project.getId())).left().on((Function)new Function<PermissionScheme, Response>(){

            @Override
            public Response apply(PermissionScheme input) {
                return ProjectPermissionSchemeResource.this.responseFactory.okNoCache(ProjectPermissionSchemeResource.this.beansFactory.toBean(input, expands));
            }
        });
    }
}

